/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pop.ssme;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ConstantLogicalKind implements Enumerator
{
    TRUE_LITERAL(0, "true", "true"),
    FALSE_LITERAL(1, "false", "false");

    public static final int TRUE = 0;
    public static final int FALSE = 1;
    private static final ConstantLogicalKind[] VALUES_ARRAY;
    public static final List<ConstantLogicalKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ConstantLogicalKind[]{TRUE_LITERAL, FALSE_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ConstantLogicalKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ConstantLogicalKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ConstantLogicalKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ConstantLogicalKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ConstantLogicalKind get(int value) {
        switch (value) {
            case 0: {
                return TRUE_LITERAL;
            }
            case 1: {
                return FALSE_LITERAL;
            }
        }
        return null;
    }

    private ConstantLogicalKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

