/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pop.ssme.compilation.utils.simulation;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.pop.ssme.compilation.utils.CompilationUtilsPlugin;
import org.osgi.framework.Bundle;

public class CreateJavaProject {
    private String bundleName;
    private String zipLocation;
    private String projectName;

    public CreateJavaProject(String bundleName, String zipLocation, String projectName) {
        this.bundleName = bundleName;
        this.zipLocation = zipLocation;
        this.projectName = projectName;
    }

    public IProject create() {
        URL interpreterZipUrl = FileLocator.find((Bundle)Platform.getBundle((String)this.bundleName), (IPath)new Path(this.zipLocation), null);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectName);
        if (project.exists()) {
            CompilationUtilsPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.pop.ssme.compilation.utils", "The project '" + this.projectName + "' already exists. The class will be generated in this project."));
            return project;
        }
        try {
            IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(this.projectName);
            description.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature"});
            ICommand command = description.newCommand();
            command.setBuilderName("org.eclipse.jdt.core.javabuilder");
            description.setBuildSpec(new ICommand[]{command});
            project.create(description, null);
            ZipInputStream zipFileStream = new ZipInputStream(interpreterZipUrl.openStream());
            ZipEntry zipEntry = zipFileStream.getNextEntry();
            String regexedProjectName = this.projectName.replaceAll("\\.", "\\.");
            while (zipEntry != null) {
                File file = new File(project.getLocation().toString(), zipEntry.getName().replaceFirst("^" + regexedProjectName + "/", ""));
                if (!zipEntry.isDirectory()) {
                    File parentFile = file.getParentFile();
                    if (parentFile != null && !parentFile.exists()) {
                        parentFile.mkdirs();
                    }
                    FileOutputStream os = null;
                    try {
                        os = new FileOutputStream(file);
                        byte[] buffer = new byte[102400];
                        while (true) {
                            int len = zipFileStream.read(buffer);
                            if (zipFileStream.available() == 0) {
                                break;
                            }
                            ((OutputStream)os).write(buffer, 0, len);
                        }
                    }
                    finally {
                        if (os != null) {
                            ((OutputStream)os).close();
                        }
                    }
                }
                zipFileStream.closeEntry();
                zipEntry = zipFileStream.getNextEntry();
            }
            project.open(null);
            project.refreshLocal(2, null);
        }
        catch (IOException e) {
            CompilationUtilsPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.pop.ssme.compilation.utils", 4, e.getMessage(), (Throwable)e));
        }
        catch (CoreException e) {
            CompilationUtilsPlugin.getDefault().getLog().log(e.getStatus());
        }
        return project;
    }
}

