/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pop.ssme.polychrony;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum IdentifierKind implements Enumerator
{
    LOCAL_LITERAL(0, "local", "local"),
    PARAMETER_LITERAL(1, "parameter", "parameter"),
    INPUT_LITERAL(2, "input", "input"),
    OUTPUT_LITERAL(3, "output", "output");

    public static final int LOCAL = 0;
    public static final int PARAMETER = 1;
    public static final int INPUT = 2;
    public static final int OUTPUT = 3;
    private static final IdentifierKind[] VALUES_ARRAY;
    public static final List<IdentifierKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new IdentifierKind[]{LOCAL_LITERAL, PARAMETER_LITERAL, INPUT_LITERAL, OUTPUT_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static IdentifierKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            IdentifierKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static IdentifierKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            IdentifierKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static IdentifierKind get(int value) {
        switch (value) {
            case 0: {
                return LOCAL_LITERAL;
            }
            case 1: {
                return PARAMETER_LITERAL;
            }
            case 2: {
                return INPUT_LITERAL;
            }
            case 3: {
                return OUTPUT_LITERAL;
            }
        }
        return PARAMETER_LITERAL;
    }

    private IdentifierKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }
}

