/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pop.ssme;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum IntervalsKind implements Enumerator
{
    LEFT_CLOSED_RIGHT_CLOSED_LITERAL(0, "LeftClosedRightClosed", "LeftClosedRightClosed"),
    LEFT_CLOSED_RIGHT_OPENED_LITERAL(1, "LeftClosedRightOpened", "LeftClosedRightOpened"),
    LEFT_OPENED_RIGHT_CLOSED_LITERAL(2, "LeftOpenedRightClosed", "LeftOpenedRightClosed"),
    LEFT_OPENED_RIGHT_OPENED_LITERAL(3, "LeftOpenedRightOpened", "LeftOpenedRightOpened");

    public static final int LEFT_CLOSED_RIGHT_CLOSED = 0;
    public static final int LEFT_CLOSED_RIGHT_OPENED = 1;
    public static final int LEFT_OPENED_RIGHT_CLOSED = 2;
    public static final int LEFT_OPENED_RIGHT_OPENED = 3;
    private static final IntervalsKind[] VALUES_ARRAY;
    public static final List<IntervalsKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new IntervalsKind[]{LEFT_CLOSED_RIGHT_CLOSED_LITERAL, LEFT_CLOSED_RIGHT_OPENED_LITERAL, LEFT_OPENED_RIGHT_CLOSED_LITERAL, LEFT_OPENED_RIGHT_OPENED_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static IntervalsKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            IntervalsKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static IntervalsKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            IntervalsKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static IntervalsKind get(int value) {
        switch (value) {
            case 0: {
                return LEFT_CLOSED_RIGHT_CLOSED_LITERAL;
            }
            case 1: {
                return LEFT_CLOSED_RIGHT_OPENED_LITERAL;
            }
            case 2: {
                return LEFT_OPENED_RIGHT_CLOSED_LITERAL;
            }
            case 3: {
                return LEFT_OPENED_RIGHT_OPENED_LITERAL;
            }
        }
        return null;
    }

    private IntervalsKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

