/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pop.ssme;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ProcessAttributeKind implements Enumerator
{
    SAFE_LITERAL(0, "safe", "safe"),
    DETERMINISTIC_LITERAL(1, "deterministic", "deterministic"),
    UNSAFE_LITERAL(2, "unsafe", "unsafe");

    public static final int SAFE = 0;
    public static final int DETERMINISTIC = 1;
    public static final int UNSAFE = 2;
    private static final ProcessAttributeKind[] VALUES_ARRAY;
    public static final List<ProcessAttributeKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ProcessAttributeKind[]{SAFE_LITERAL, DETERMINISTIC_LITERAL, UNSAFE_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ProcessAttributeKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ProcessAttributeKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ProcessAttributeKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ProcessAttributeKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ProcessAttributeKind get(int value) {
        switch (value) {
            case 0: {
                return SAFE_LITERAL;
            }
            case 1: {
                return DETERMINISTIC_LITERAL;
            }
            case 2: {
                return UNSAFE_LITERAL;
            }
        }
        return null;
    }

    private ProcessAttributeKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

