/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pop.ssme.compilation.utils.jobs;

import java.util.LinkedList;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.pop.ssme.compilation.utils.CompilationUtilsPlugin;
import org.eclipse.pop.ssme.compilation.utils.popup.actions.CompilationUtils;
import org.eclipse.pop.ssme.compilation.utils.simulation.CreateJavaProject;
import org.eclipse.pop.ssme.polychrony.GraphValue;
import org.eclipse.pop.ssme.polychrony.PkPlugin;
import org.eclipse.pop.ssme.polychrony.utils.PolychronyConsole;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class CompilingMethods {
    public IStatus getErrorCompilationStatus(String message) {
        return new Status(4, "org.eclipse.pop.ssme.compilation.utils", message);
    }

    private boolean askUserForGeneration(final String windowTitle, final String message) {
        final LinkedList result = new LinkedList();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                result.add(MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)windowTitle, (String)message));
            }
        });
        return (Boolean)result.get(0);
    }

    public IStatus abstraction(GraphValue graph) {
        if (PkPlugin.getServices().separatedCompilingPoly(graph.getGraph(), true)) {
            return Status.OK_STATUS;
        }
        return this.getErrorCompilationStatus("Error during the abstraction building step");
    }

    public IStatus boolean2Events(GraphValue graph) {
        if (PkPlugin.getServices().transformBooleanClocks2Events(graph.getGraph())) {
            return Status.OK_STATUS;
        }
        return this.getErrorCompilationStatus("Error during the boolean to events transformation step");
    }

    public IStatus clockCalculus(GraphValue graph) {
        graph = PkPlugin.getServices().DCGBasic2DCGPoly(graph.getGraph());
        if (PkPlugin.getServices().setIntrinsicClocks(graph.getGraph())) {
            PkPlugin.getServices().nonProductiveSignalElimination(graph.getGraph());
            return Status.OK_STATUS;
        }
        return this.getErrorCompilationStatus("Error during the clock calculus step");
    }

    public IStatus cluster(GraphValue graph) {
        boolean generate;
        PkPlugin.getServices().setIntrinsicClocks(graph.getGraph());
        graph = PkPlugin.getServices().DCGPoly2DCGBool(graph.getGraph());
        if (graph.getReturnCode() == 1) {
            return this.getErrorCompilationStatus("Error during the booleanizing operation");
        }
        PkPlugin.getServices().nonProductiveSignalElimination(graph.getGraph());
        PkPlugin.getServices().setClockDependences(graph.getGraph());
        boolean bl = generate = !PkPlugin.getServices().hasUnsolvedClockConstraints(graph.getGraph());
        if (!generate) {
            generate = this.askUserForGeneration("Force the clustering ?", "There are some unresolved constraints. Do you want to force the clustering operation ?");
        }
        if (!generate) {
            return Status.CANCEL_STATUS;
        }
        if (PkPlugin.getServices().hasStaticCycle(graph.getGraph(), false)) {
            PkPlugin.getServices().nonProductiveSignalElimination(graph.getGraph());
            PkPlugin.getServices().phylumClustering(graph.getGraph());
            PkPlugin.getServices().nonProductiveSignalElimination(graph.getGraph());
            return Status.OK_STATUS;
        }
        return this.getErrorCompilationStatus("Error during the cycle detection operation");
    }

    public IStatus DCGPoly2DCGBool(GraphValue graph) {
        graph = PkPlugin.getServices().DCGPoly2DCGBool(graph.getGraph());
        if (graph.getReturnCode() == 1) {
            return this.getErrorCompilationStatus("Error during the events to Booleans Booleanizing operation");
        }
        if (PkPlugin.getServices().nonProductiveSignalElimination(graph.getGraph())) {
            return Status.OK_STATUS;
        }
        return this.getErrorCompilationStatus("Error during the events to booleans pruning operation");
    }

    public IStatus Flattening(GraphValue graph) {
        graph = PkPlugin.getServices().DCGBool2DCGFlat(graph.getGraph());
        if (graph.getReturnCode() == 0) {
            return Status.OK_STATUS;
        }
        return this.getErrorCompilationStatus("Error during the flattening step");
    }

    public IStatus retiming(GraphValue graph) {
        if (PkPlugin.getServices().moveIn2OutDelays(graph.getGraph())) {
            return Status.OK_STATUS;
        }
        return this.getErrorCompilationStatus("Error during the retiming step");
    }

    public IStatus sequentializing(GraphValue graph, long tree, boolean clustersApplied) {
        if (!clustersApplied) {
            boolean generate;
            if (!PkPlugin.getServices().delayTreeBuild(graph.getGraph())) {
                return this.getErrorCompilationStatus("Error during the delay Tree generation");
            }
            PkPlugin.getServices().nonProductiveSignalElimination(graph.getGraph());
            PkPlugin.getServices().setClockDependences(graph.getGraph());
            boolean bl = generate = !PkPlugin.getServices().hasUnsolvedClockConstraints(graph.getGraph());
            if (!generate) {
                generate = this.askUserForGeneration("Force the sequentializing ?", "There are some unresolved constraints. Do you want to force the sequentializing operation ?");
            }
            if (!generate) {
                return Status.CANCEL_STATUS;
            }
            if (!PkPlugin.getServices().hasStaticCycle(graph.getGraph(), false)) {
                return this.getErrorCompilationStatus("Error during the cycle detection operation");
            }
        }
        if ((graph = PkPlugin.getServices().Serializing(graph.getGraph(), true, true, true, true)).getReturnCode() == 0) {
            return Status.OK_STATUS;
        }
        return this.getErrorCompilationStatus("Error during the sequentializing operation");
    }

    public IStatus unify(GraphValue graph) {
        if (PkPlugin.getServices().removeSignalClones(graph.getGraph())) {
            return Status.OK_STATUS;
        }
        return this.getErrorCompilationStatus("Error during the signal unification step");
    }

    public IStatus generateC(long graph, boolean abstractionApplied) {
        boolean res = abstractionApplied ? PkPlugin.getServices().genCodeCSeparate(graph) : PkPlugin.getServices().genCodeC(graph, true, true, true);
        if (res) {
            return Status.OK_STATUS;
        }
        return this.getErrorCompilationStatus("Error during the C code generation");
    }

    public IStatus generateCPP(long graph, boolean abstractionApplied) {
        boolean res = abstractionApplied ? PkPlugin.getServices().genCodeCPPSeparate(graph) : PkPlugin.getServices().genCodeCPP(graph, true, true, true);
        if (res) {
            return Status.OK_STATUS;
        }
        return this.getErrorCompilationStatus("Error during the CPP code generation");
    }

    public IStatus generateJava(long graph, IPath targetDir, boolean abstractionApplied, CompilationUtils compilationUtils) {
        PolychronyConsole.printInfo((String)("\n   ==> Create the Java project: " + targetDir.lastSegment() + "\n"));
        CreateJavaProject project = new CreateJavaProject("org.eclipse.pop.ssme.compilation.utils", "javalibs/simulation.zip", targetDir.lastSegment());
        IProject pr = project.create();
        compilationUtils.getResources().add((IResource)pr);
        IFolder dir = pr.getFolder("src");
        if (!dir.exists()) {
            try {
                dir.create(true, true, null);
                PkPlugin.getPrinter().setOutputDirectory(dir.getLocation().toOSString());
            }
            catch (CoreException e) {
                CompilationUtilsPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.pop.ssme.compilation.utils", 0, e.getMessage(), (Throwable)e));
            }
        }
        boolean res = abstractionApplied ? PkPlugin.getServices().genCodeJavaSeparate(graph) : PkPlugin.getServices().genCodeJava(graph, true, true, true);
        PkPlugin.getPrinter().setOutputDirectory(targetDir.toOSString());
        if (res) {
            return Status.OK_STATUS;
        }
        return this.getErrorCompilationStatus("Error during the Java code generation");
    }

    public IStatus generateLustre(long graph) {
        if (PkPlugin.getServices().LustreUnparse(graph)) {
            return Status.OK_STATUS;
        }
        return this.getErrorCompilationStatus("Error during the Lustre code generation");
    }

    public IStatus generateProfiling(long graph) {
        if (PkPlugin.getServices().applyTabularMorphism(graph)) {
            return Status.OK_STATUS;
        }
        return this.getErrorCompilationStatus("Error during the profiling");
    }

    public IStatus generateSigali(long graph) {
        if (PkPlugin.getServices().SigaliPrintExtraction(graph)) {
            return Status.OK_STATUS;
        }
        return this.getErrorCompilationStatus("Error during the Sigali code generation");
    }

    public IStatus generateSignal(long tree, IPath fileDirectory) {
        PkPlugin.getPrinter().setOutputDirectory(fileDirectory.toOSString());
        if (!PkPlugin.getPrinter().printTree(tree)) {
            return this.getErrorCompilationStatus("Error during the Signal code generation");
        }
        return Status.OK_STATUS;
    }

    public IStatus generateSignalLIS(long tree) {
        boolean signalLISPrinted = PkPlugin.getServices().printSignalLIS(tree, 0L);
        if (!signalLISPrinted) {
            return this.getErrorCompilationStatus("Error during the Signal code generation");
        }
        return Status.OK_STATUS;
    }

    public IStatus generateSignalTRA(long graph) {
        if (PkPlugin.getServices().unparse(graph)) {
            return Status.OK_STATUS;
        }
        return this.getErrorCompilationStatus("Error during the Signal code generation");
    }

    public IStatus generateSignalAbstraction(long graph) {
        if (PkPlugin.getServices().unparseAbstraction(graph)) {
            return Status.OK_STATUS;
        }
        return this.getErrorCompilationStatus("Error during the Signal Abstraction generation");
    }

    public IStatus generateSSME(long tree, IPath fileDirectory) {
        PkPlugin.getPrinter().setOutputDirectory(fileDirectory.toOSString());
        if (PkPlugin.getServices().signal2SSME(tree, fileDirectory.toOSString())) {
            return Status.OK_STATUS;
        }
        return this.getErrorCompilationStatus("Error during the generation of the Signal model file.");
    }

    public IStatus generateSyndex(long graph) {
        if (PkPlugin.getServices().SynDExUnparse(graph)) {
            return Status.OK_STATUS;
        }
        return this.getErrorCompilationStatus("Error during the SynDEx code generation");
    }
}

