/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pop.ssme.polychrony;

import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.pop.ssme.polychrony.ExclusiveClockLevelKind;
import org.eclipse.pop.ssme.polychrony.GraphValue;
import org.eclipse.pop.ssme.polychrony.PKTrees;
import org.eclipse.pop.ssme.polychrony.PkPlugin;
import org.eclipse.pop.ssme.polychrony.SignalParser;
import org.eclipse.pop.ssme.polychrony.SignalTreeBuilting;
import org.eclipse.pop.ssme.polychrony.SignalTreeComment;
import org.eclipse.pop.ssme.polychrony.SignalTreeExploring;
import org.eclipse.pop.ssme.polychrony.SignalTreePrinter;
import org.eclipse.pop.ssme.polychrony.traceability.TreesInterface;

public class PKServices {
    private static final String NATIVE_LIB_NOT_FOUND = "The native library for POP is not available.";
    private static final String NO_NATIVE_RESOURCES = "Cannot find native resources to initialize the compiler";
    private static final String BAD_SIGNALTOOLBOX_VERSION = "Bad Signal ToolBox version, expected version: ";
    static boolean SignaltoolBoxLoaded = false;
    public static final PKServices INSTANCE;
    private SignalParser parser;
    private SignalTreePrinter printer;
    private SignalTreeBuilting builder;
    private PKTrees treeAPI;
    private SignalTreeComment comment;
    private TreesInterface treesInterface;
    private SignalTreeExploring explorer;

    static {
        try {
            String str = String.valueOf(System.getenv("Signal_obj")) + File.separatorChar + System.mapLibraryName("SignalToolBoxEclipse_4.20");
            System.load(str);
            SignaltoolBoxLoaded = true;
        }
        catch (UnsatisfiedLinkError ule) {
            PkPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.pop.ssme.polychrony", NATIVE_LIB_NOT_FOUND, (Throwable)ule));
        }
        INSTANCE = new PKServices();
    }

    private PKServices() {
        String vpKVersion;
        String pK_Signal_bin = System.getenv("Signal_bin");
        if (pK_Signal_bin == null) {
            PkPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.pop.ssme.polychrony", NO_NATIVE_RESOURCES));
        }
        if ((vpKVersion = System.getenv("pK_VERSION")) == null) {
            vpKVersion = "_UNKNOWN_";
        }
        if (SignaltoolBoxLoaded) {
            try {
                this.newMachine();
                IPreferenceStore pref = PkPlugin.getDefault().getPreferenceStore();
                this.setEnv("Signal_bin", pK_Signal_bin);
                this.setEnv("pK_VERSION", vpKVersion);
                String value = pref.getString("polychronyLibraryPath");
                if (!"".equals(value)) {
                    value = String.valueOf(value) + File.pathSeparator;
                }
                value = String.valueOf(value) + System.getenv("SignalLib_Std");
                this.setEnv("SIGNAL_LIBRARY_PATH", value);
                int val = pref.getInt("maxTypeTableSize");
                if (val <= 0) {
                    val = 4096;
                }
                this.setEnv("SHELL_TypeTableMaxSize", "" + val);
                val = pref.getInt("polychronyTreeMemorySize");
                if (val <= 0) {
                    val = 60000000;
                }
                this.setEnv("T_MEM_ARB", "" + val);
                val = pref.getInt("polychronyStringMemorySize");
                if (val <= 0) {
                    val = 0x100000;
                }
                this.setEnv("T_MEM_CHAIN", "" + val);
                this.initMachine();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.parser = new SignalParser();
            this.printer = new SignalTreePrinter();
            this.builder = new SignalTreeBuilting();
            this.treeAPI = new PKTrees();
            this.comment = new SignalTreeComment();
            this.treesInterface = new TreesInterface();
            this.explorer = new SignalTreeExploring();
        }
    }

    public boolean isSignalToolBoxLoaded() {
        return SignaltoolBoxLoaded;
    }

    public String getWaitedVersion() {
        return "4.20";
    }

    public SignalParser getParser() {
        return this.parser;
    }

    public SignalTreePrinter getPrinter() {
        return this.printer;
    }

    public SignalTreeBuilting getTreeBuilder() {
        return this.builder;
    }

    public SignalTreeExploring getTreeExplorer() {
        return this.explorer;
    }

    public PKTrees getTreeAPI() {
        return this.treeAPI;
    }

    public SignalTreeComment getCommentAPI() {
        return this.comment;
    }

    public TreesInterface getTraceabilityAPI() {
        return this.treesInterface;
    }

    private synchronized native void newMachine();

    private synchronized native void initMachine();

    public synchronized native void resetMachine();

    public synchronized native void displayWarnings(boolean var1);

    public synchronized native void finalize();

    public synchronized native GraphValue tree2DCG(long var1, boolean var3, long var4, boolean var6, String var7, boolean var8, boolean var9);

    public synchronized native boolean printSignalLIS(long var1, long var3);

    public synchronized native boolean signal2SSME(long var1, String var3);

    public synchronized native boolean signal2SSME(String var1, String var2);

    public synchronized native boolean signal2SME(String var1, String var2);

    public synchronized native boolean signal2SME(long var1, String var3);

    public synchronized native boolean genCodeC(long var1, boolean var3, boolean var4, boolean var5);

    public synchronized native boolean genCodeCPP(long var1, boolean var3, boolean var4, boolean var5);

    public synchronized native boolean genCodeCPPSeparate(long var1);

    public synchronized native boolean genCodeCSeparate(long var1);

    public synchronized native boolean DotUnparse(long var1);

    public synchronized native boolean genCodeJava(long var1, boolean var3, boolean var4, boolean var5);

    public synchronized native boolean genCodeJavaSeparate(long var1);

    public synchronized native boolean expressionExpand(long var1);

    public synchronized native boolean unparse(long var1);

    public synchronized native long produce(long var1);

    public synchronized native long produceFlat(long var1);

    public synchronized native boolean SynDExUnparse(long var1);

    public synchronized native boolean genCodeJavaThreads(long var1, boolean var3, boolean var4, boolean var5);

    public synchronized native boolean IGraph2Vhdl(long var1);

    public synchronized native boolean SigaliPrintExtraction(long var1);

    public synchronized native long produceInterfaceAbstraction(long var1);

    public synchronized native long buildAbstraction(long var1);

    public synchronized native void memoryOptimizations(long var1, boolean var3);

    public synchronized native GraphValue DCGPoly2DCGBool(long var1);

    public synchronized native boolean transformBooleanClocks2Events(long var1);

    public synchronized native void separateBooleansOthers(long var1);

    public synchronized native GraphValue DCGBasic2DCGPoly(long var1);

    public synchronized native boolean setIntrinsicClocks(long var1);

    public synchronized native boolean dependenceReinforcing(long var1);

    public synchronized native boolean addExceptionsForConstraints(long var1);

    public synchronized native boolean hasStaticCycle(long var1, boolean var3);

    public synchronized native boolean splitDefaultDefinitions(long var1);

    public synchronized native boolean setDelayMemoryOverloading(long var1);

    public synchronized native boolean moveIn2OutDelays(long var1);

    native void computeClockExclusions(long var1, int var3);

    public synchronized void computeClockExclusions(long graphNode, ExclusiveClockLevelKind level) {
        this.computeClockExclusions(graphNode, level.getValue());
    }

    public synchronized native boolean expandModelReference(long var1, boolean var3);

    public synchronized native boolean breakCPG(long var1);

    public synchronized native boolean checkExplicitTyping(long var1);

    public synchronized native boolean printCHStatistics(long var1);

    public synchronized native boolean phylumClustering(long var1);

    public synchronized native boolean buildClockProcessInterface(long var1);

    public synchronized native boolean hasUnsolvedClockConstraints(long var1);

    public synchronized native boolean delayTreeBuild(long var1);

    public synchronized native boolean groupPartialDefinitions(long var1);

    public synchronized native boolean applyTabularMorphism(long var1);

    public synchronized native boolean buildIOClockSubHierarchy(long var1, boolean var3);

    public synchronized native boolean nonProductiveSignalElimination(long var1);

    public synchronized native boolean removeSignalEqualities(long var1);

    public synchronized native boolean separatedCompilingPoly(long var1, boolean var3);

    public synchronized native GraphValue Serializing(long var1, boolean var3, boolean var4, boolean var5, boolean var6);

    public synchronized native boolean setClockDependences(long var1);

    public synchronized native boolean unparseAbstraction(long var1);

    public synchronized native boolean splitDataStructure(long var1);

    public synchronized native void separateStatesOthers(long var1);

    public synchronized native void computeProductiveClockStateVar(long var1);

    public synchronized native GraphValue DCGBool2DCGFlat(long var1);

    public synchronized native long produceSubgraph(long var1, int var3);

    public synchronized native boolean substituteExpr2Var(long var1, int var3);

    public synchronized native boolean computeIOTransitiveClosure(long var1);

    public synchronized native boolean removeSignalClones(long var1);

    public synchronized native void computeProductiveClock(long var1);

    public synchronized native boolean LustreUnparse(long var1);

    public synchronized native long parse(String var1, String var2);

    public synchronized native void setEnv(String var1, String var2);

    public synchronized native String getEnv(String var1);
}

