/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pop.ssme.polychrony.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PathEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.pop.ssme.polychrony.PkPlugin;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class SsmePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IPreferenceStore ps = PkPlugin.getDefault().getPreferenceStore();
    private PathEditor libraryPath;
    private IntegerFieldEditor typeTableSize;
    private IntegerFieldEditor treeMemorySize;
    private IntegerFieldEditor stringMemorySize;

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout containerLayout = new GridLayout();
        containerLayout.marginWidth = 0;
        containerLayout.marginHeight = 0;
        container.setLayout((Layout)containerLayout);
        container.setLayoutData((Object)new GridData(1808));
        this.createHeader(container);
        this.createFields(container);
        this.initDefaultValues();
        this.loadPreferences();
        return container;
    }

    private void initDefaultValues() {
        String value = System.getenv("SignalLib_Std");
        if (value != null) {
            this.ps.setDefault("polychronyLibraryPath", value);
        }
        this.ps.setDefault("maxTypeTableSize", 4096);
        this.ps.setDefault("polychronyTreeMemorySize", 60000000);
        this.ps.setDefault("polychronyStringMemorySize", 0x100000);
    }

    private void loadPreferences() {
        this.libraryPath.load();
        this.typeTableSize.load();
        this.treeMemorySize.load();
        this.stringMemorySize.load();
    }

    private void storePreferences() {
        this.libraryPath.store();
        this.typeTableSize.store();
        this.treeMemorySize.store();
        this.stringMemorySize.store();
    }

    private void loadDefaultPreferences() {
        this.libraryPath.loadDefault();
        this.typeTableSize.loadDefault();
        this.treeMemorySize.loadDefault();
        this.stringMemorySize.loadDefault();
    }

    private void createHeader(Composite parent) {
        new Label(parent, 64).setText("General settings for the POP-SSME editors");
    }

    private void createFields(Composite parent) {
        Composite fieldsContainer = new Composite(parent, 0);
        fieldsContainer.setLayout((Layout)new GridLayout());
        fieldsContainer.setLayoutData((Object)new GridData(768));
        this.libraryPath = new PathEditor("polychronyLibraryPath", "Search paths for POP.ibraries", "Select directories of POP.ibraries", fieldsContainer);
        this.libraryPath.setPreferenceStore(this.ps);
        this.typeTableSize = new IntegerFieldEditor("maxTypeTableSize", "Maximum number of entry in the type table (only updated after reboot)", fieldsContainer);
        this.typeTableSize.setPreferenceStore(this.ps);
        this.treeMemorySize = new IntegerFieldEditor("polychronyTreeMemorySize", "Memory size (in bytes) for the internal tree structure (only updated after reboot)", fieldsContainer);
        this.treeMemorySize.setPreferenceStore(this.ps);
        this.stringMemorySize = new IntegerFieldEditor("polychronyStringMemorySize", "Memory size (in bytes) for the string structure (only updated after reboot)", fieldsContainer);
        this.stringMemorySize.setPreferenceStore(this.ps);
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        this.storePreferences();
        String value = this.ps.getString("polychronyLibraryPath");
        PkPlugin.getServices().setEnv("SIGNAL_LIBRARY_PATH", value);
        return super.performOk();
    }

    protected void performDefaults() {
        this.loadDefaultPreferences();
        super.performDefaults();
    }
}

