/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pop.ssme.polychrony.utils;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.ui.util.EditUIMarkerHelper;
import org.eclipse.pop.ssme.polychrony.PkPlugin;
import org.eclipse.pop.ssme.polychrony.utils.ResourceHelper;

public class PolychronyMarkerHelper
extends EditUIMarkerHelper {
    public static final PolychronyMarkerHelper INSTANCE = new PolychronyMarkerHelper();
    public static final String ID_MARKER = "org.eclipse.emf.ecore.diagnostic";

    protected String getMarkerID() {
        return ID_MARKER;
    }

    public void createMarkers(IFile file, Diagnostic diagnostic) {
        try {
            this.createMarkers((IResource)file, diagnostic, null);
        }
        catch (CoreException ce) {
            PkPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.pop.ssme.polychrony", 0, "An exception has been thrown during the creation of a marker problem on " + file, (Throwable)ce));
        }
    }

    public void createMarkers(Resource resource, Diagnostic diagnostic) {
        try {
            this.createMarkers((IResource)this.getFile(resource), diagnostic, null);
        }
        catch (CoreException ce) {
            PkPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.pop.ssme.polychrony", 0, "An exception has been thrown during the creation of a marker problem on " + this.getFile(resource), (Throwable)ce));
        }
    }

    protected String composeMessage(Diagnostic diagnostic, Diagnostic parentDiagnostic) {
        String parentMessage;
        String message = diagnostic.getMessage();
        if (parentDiagnostic != null && (parentMessage = parentDiagnostic.getMessage()) != null) {
            message = message != null ? String.valueOf(parentMessage) + ". " + message : parentMessage;
        }
        return message;
    }

    protected void adjustMarker(IMarker marker, Diagnostic diagnostic, Diagnostic parentDiagnostic) throws CoreException {
        List data = diagnostic.getData();
        StringBuilder relatedURIs = new StringBuilder();
        boolean first = true;
        for (Object object : data) {
            if (!(object instanceof EObject)) continue;
            EObject eObject = (EObject)object;
            if (first) {
                first = false;
                marker.setAttribute("uri", (Object)ResourceHelper.getURI(eObject).toString());
                continue;
            }
            if (relatedURIs.length() != 0) {
                relatedURIs.append(' ');
            }
            relatedURIs.append(URI.encodeFragment((String)ResourceHelper.getURI(eObject).toString(), (boolean)false));
        }
        if (relatedURIs.length() > 0) {
            marker.setAttribute("relatedURIs", (Object)relatedURIs.toString());
        }
        super.adjustMarker(marker, diagnostic, parentDiagnostic);
    }
}

