/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.compilation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Functionality Kind</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see org.eclipse.pop.ssme.compilation.SsmeCompPackage#getFunctionalityKind()
 * @model annotation="http://www.topcased.org/uuid uuid='_blv9kcM_EduFJvhn52JvCw'"
 * @generated
 */
public enum FunctionalityKind implements Enumerator {
	/**
	 * The '<em><b>Retiming</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #RETIMING
	 * @generated
	 * @ordered
	 */
	RETIMING_LITERAL(0, "Retiming", "Retiming"),

	/**
	 * The '<em><b>Boolean2 Events</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #BOOLEAN2_EVENTS
	 * @generated
	 * @ordered
	 */
	BOOLEAN2_EVENTS_LITERAL(1, "Boolean2Events", "Boolean to Events"),

	/**
	 * The '<em><b>Signal Unifications</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SIGNAL_UNIFICATIONS
	 * @generated
	 * @ordered
	 */
	SIGNAL_UNIFICATIONS_LITERAL(2, "SignalUnifications", "Signal Unifications"),

	/**
	 * The '<em><b>Clock Calculus</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CLOCK_CALCULUS
	 * @generated
	 * @ordered
	 */
	CLOCK_CALCULUS_LITERAL(3, "ClockCalculus", "Clock Calculus"),

	/**
	 * The '<em><b>Events2 Boolean</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #EVENTS2_BOOLEAN
	 * @generated
	 * @ordered
	 */
	EVENTS2_BOOLEAN_LITERAL(4, "Events2Boolean", "Events to Boolean"),

	/**
	 * The '<em><b>Abstraction</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ABSTRACTION
	 * @generated
	 * @ordered
	 */
	ABSTRACTION_LITERAL(5, "Abstraction", "Abstraction"),

	/**
	 * The '<em><b>Clustering</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CLUSTERING
	 * @generated
	 * @ordered
	 */
	CLUSTERING_LITERAL(6, "Clustering", "Sequential Clustering"),

	/**
	 * The '<em><b>Sequentializing</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SEQUENTIALIZING
	 * @generated
	 * @ordered
	 */
	SEQUENTIALIZING_LITERAL(7, "Sequentializing", "Sequentializing"),

	/**
	 * The '<em><b>Flattening</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #FLATTENING
	 * @generated
	 * @ordered
	 */
	FLATTENING_LITERAL(8, "Flattening", "Flattening (STS)");

	/**
	 * The '<em><b>Retiming</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Re-timing: It performs a shift register transformation. It rewrites synchronous function f
	 * such that Y := f(X1 $ m1 init V1,...,Xn $ mn init Vm) into Y := y' $ j init f(V1',...,Vm') and
	 * y' := f(X1 $ m1' init V1",...., Xm $ mn' init Vm").
	 * <!-- end-model-doc -->
	 * @see #RETIMING_LITERAL
	 * @model name="Retiming"
	 *        annotation="http://www.topcased.org/uuid uuid='_blv9ksM_EduFJvhn52JvCw'"
	 * @generated
	 * @ordered
	 */
	public static final int RETIMING = 0;

	/**
	 * The '<em><b>Boolean2 Events</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Booleans to events: It rewrites boolean expressions of under-sampling for logical and
	 * relational operators. the goal is to prove synchronization constraints of the system.
	 * - the rewriting of the booleans expressions referenced in an extraction (when E) when E is
	 * not a "free" condition and not declared as an assumption. For example, the expression
	 * when (A and B) is equal to the clock intersection of when (A) and when (B).
	 * So, "classical boolean rules" completed with some specific rules induced by the
	 * extraction and merging Signal operators are applied to the system.
	 * - the rewriting of the boolean expressions referenced in the extraction (when E) when E is
	 * assumed to be an assertion: the expression assert(E) specifies that E is always true when
	 * it is available. So it induces that when E is equivalent to the clock of E.
	 * <!-- end-model-doc -->
	 * @see #BOOLEAN2_EVENTS_LITERAL
	 * @model name="Boolean2Events" literal="Boolean to Events"
	 *        annotation="http://www.topcased.org/uuid uuid='_bl5ugMM_EduFJvhn52JvCw'"
	 * @generated
	 * @ordered
	 */
	public static final int BOOLEAN2_EVENTS = 1;

	/**
	 * The '<em><b>Signal Unifications</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Signal unifications: this operation consists in the merge of nodes into one node when their
	 * definition expression are equal (syntactically).
	 * <!-- end-model-doc -->
	 * @see #SIGNAL_UNIFICATIONS_LITERAL
	 * @model name="SignalUnifications" literal="Signal Unifications"
	 *        annotation="http://www.topcased.org/uuid uuid='_bmC4cMM_EduFJvhn52JvCw'"
	 * @generated
	 * @ordered
	 */
	public static final int SIGNAL_UNIFICATIONS = 2;

	/**
	 * The '<em><b>Clock Calculus</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Clock calculus: it performs the resolution of the clock systems using a triangularization
	 * technique. A BDD-based data structure is used. Here, only the study of static properties is
	 * performed. They allow to characterized the set of states in which the automaton associated
	 * to a program can evolve, independently of initial values, and the set of the transitions
	 * between these states. The result is a forest of clock trees.
	 * <!-- end-model-doc -->
	 * @see #CLOCK_CALCULUS_LITERAL
	 * @model name="ClockCalculus" literal="Clock Calculus"
	 *        annotation="http://www.topcased.org/uuid uuid='_bmMpcMM_EduFJvhn52JvCw'"
	 * @generated
	 * @ordered
	 */
	public static final int CLOCK_CALCULUS = 3;

	/**
	 * The '<em><b>Events2 Boolean</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Events to booleans (bDC+): it performs the inter-format DC+ (that constrains event objects,
	 * forest of trees of clocks) to bDC+ (without event objects, a tree of boolean clock)
	 * translation.
	 * <!-- end-model-doc -->
	 * @see #EVENTS2_BOOLEAN_LITERAL
	 * @model name="Events2Boolean" literal="Events to Boolean"
	 *        annotation="http://www.topcased.org/uuid uuid='_bmVzYMM_EduFJvhn52JvCw'"
	 * @generated
	 * @ordered
	 */
	public static final int EVENTS2_BOOLEAN = 4;

	/**
	 * The '<em><b>Abstraction</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Abstraction: it computes the abstraction of the program (I/O data dependences, I/O clock
	 * relations, the "black Box" or the "grey Box" abstraction representation). This abstraction is
	 * useful for separated compiling.
	 * <!-- end-model-doc -->
	 * @see #ABSTRACTION_LITERAL
	 * @model name="Abstraction"
	 *        annotation="http://www.topcased.org/uuid uuid='_bmfkYMM_EduFJvhn52JvCw'"
	 * @generated
	 * @ordered
	 */
	public static final int ABSTRACTION = 5;

	/**
	 * The '<em><b>Clustering</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Sequential clustering: it performs the following partitioning (called input train). Two nodes
	 * are in the same set if and only if they depends on the same subset of inputs signals of the
	 * graph. The graph is modified. The nodes are clustered into sub-graphs. The internal
	 * representation must be in bDC+ sub-format.
	 * <!-- end-model-doc -->
	 * @see #CLUSTERING_LITERAL
	 * @model name="Clustering" literal="Sequential Clustering"
	 *        annotation="http://www.topcased.org/uuid uuid='_bmpVYMM_EduFJvhn52JvCw'"
	 * @generated
	 * @ordered
	 */
	public static final int CLUSTERING = 6;

	/**
	 * The '<em><b>Sequentializing</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Sequentializing (sbDC+): it performs the inter-format bDC+ (a tree of boolean clocks) to
	 * sbDC+ («sequentialized boolean dc+») translation. The internal representation must be in
	 * bDC+ sub-format. The nodes of the internal representation are ordered. The assert nodes are
	 * visible for code generation (code will be generated for verifying assumptions at run time).
	 * <!-- end-model-doc -->
	 * @see #SEQUENTIALIZING_LITERAL
	 * @model name="Sequentializing"
	 *        annotation="http://www.topcased.org/uuid uuid='_bmyfUMM_EduFJvhn52JvCw'"
	 * @generated
	 * @ordered
	 */
	public static final int SEQUENTIALIZING = 7;

	/**
	 * The '<em><b>Flattening</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Flattening (STS): it performs the inter-format bDC+ (a tree of boolean clocks) to STS (a tree
	 * of boolean clocks reduces to one level) translation. The internal representation must be in
	 * bDC+ sub-format.
	 * <!-- end-model-doc -->
	 * @see #FLATTENING_LITERAL
	 * @model name="Flattening" literal="Flattening (STS)"
	 *        annotation="http://www.topcased.org/uuid uuid='_bm8QUMM_EduFJvhn52JvCw'"
	 * @generated
	 * @ordered
	 */
	public static final int FLATTENING = 8;

	/**
	 * An array of all the '<em><b>Functionality Kind</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final FunctionalityKind[] VALUES_ARRAY =
		new FunctionalityKind[] {
			RETIMING_LITERAL,
			BOOLEAN2_EVENTS_LITERAL,
			SIGNAL_UNIFICATIONS_LITERAL,
			CLOCK_CALCULUS_LITERAL,
			EVENTS2_BOOLEAN_LITERAL,
			ABSTRACTION_LITERAL,
			CLUSTERING_LITERAL,
			SEQUENTIALIZING_LITERAL,
			FLATTENING_LITERAL,
		};

	/**
	 * A public read-only list of all the '<em><b>Functionality Kind</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<FunctionalityKind> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Functionality Kind</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static FunctionalityKind get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			FunctionalityKind result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Functionality Kind</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static FunctionalityKind getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			FunctionalityKind result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Functionality Kind</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static FunctionalityKind get(int value) {
		switch (value) {
			case RETIMING: return RETIMING_LITERAL;
			case BOOLEAN2_EVENTS: return BOOLEAN2_EVENTS_LITERAL;
			case SIGNAL_UNIFICATIONS: return SIGNAL_UNIFICATIONS_LITERAL;
			case CLOCK_CALCULUS: return CLOCK_CALCULUS_LITERAL;
			case EVENTS2_BOOLEAN: return EVENTS2_BOOLEAN_LITERAL;
			case ABSTRACTION: return ABSTRACTION_LITERAL;
			case CLUSTERING: return CLUSTERING_LITERAL;
			case SEQUENTIALIZING: return SEQUENTIALIZING_LITERAL;
			case FLATTENING: return FLATTENING_LITERAL;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private FunctionalityKind(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //FunctionalityKind
