/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.compilation;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.eclipse.pop.ssme.compilation.SsmeCompFactory
 * @model kind="package"
 *        annotation="http://www.topcased.org/uuid uuid='_26vDkMM9EduFJvhn52JvCw'"
 * @generated
 */
public interface SsmeCompPackage extends EPackage {
	
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "compilation";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.irisa.fr/espresso/SsmeCompilation.ecore";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "compilation";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	SsmeCompPackage eINSTANCE = org.eclipse.pop.ssme.compilation.impl.SsmeCompPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.compilation.impl.ScenarioImpl <em>Scenario</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.compilation.impl.ScenarioImpl
	 * @see org.eclipse.pop.ssme.compilation.impl.SsmeCompPackageImpl#getScenario()
	 * @generated
	 */
	int SCENARIO = 0;

	/**
	 * The feature id for the '<em><b>Elements</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCENARIO__ELEMENTS = 0;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCENARIO__DESCRIPTION = 1;

	/**
	 * The feature id for the '<em><b>Display Warnings</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCENARIO__DISPLAY_WARNINGS = 2;

	/**
	 * The number of structural features of the '<em>Scenario</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCENARIO_FEATURE_COUNT = 3;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.compilation.impl.ScenarioItemImpl <em>Scenario Item</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.compilation.impl.ScenarioItemImpl
	 * @see org.eclipse.pop.ssme.compilation.impl.SsmeCompPackageImpl#getScenarioItem()
	 * @generated
	 */
	int SCENARIO_ITEM = 3;

	/**
	 * The number of structural features of the '<em>Scenario Item</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCENARIO_ITEM_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.compilation.impl.FunctionalityImpl <em>Functionality</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.compilation.impl.FunctionalityImpl
	 * @see org.eclipse.pop.ssme.compilation.impl.SsmeCompPackageImpl#getFunctionality()
	 * @generated
	 */
	int FUNCTIONALITY = 1;

	/**
	 * The feature id for the '<em><b>Kind</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTIONALITY__KIND = SCENARIO_ITEM_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Functionality</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTIONALITY_FEATURE_COUNT = SCENARIO_ITEM_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.compilation.impl.GeneratorImpl <em>Generator</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.compilation.impl.GeneratorImpl
	 * @see org.eclipse.pop.ssme.compilation.impl.SsmeCompPackageImpl#getGenerator()
	 * @generated
	 */
	int GENERATOR = 2;

	/**
	 * The feature id for the '<em><b>Kind</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERATOR__KIND = SCENARIO_ITEM_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Generator</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERATOR_FEATURE_COUNT = SCENARIO_ITEM_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.compilation.GeneratorKind <em>Generator Kind</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.compilation.GeneratorKind
	 * @see org.eclipse.pop.ssme.compilation.impl.SsmeCompPackageImpl#getGeneratorKind()
	 * @generated
	 */
	int GENERATOR_KIND = 4;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.compilation.FunctionalityKind <em>Functionality Kind</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.compilation.FunctionalityKind
	 * @see org.eclipse.pop.ssme.compilation.impl.SsmeCompPackageImpl#getFunctionalityKind()
	 * @generated
	 */
	int FUNCTIONALITY_KIND = 5;


	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.compilation.Scenario <em>Scenario</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Scenario</em>'.
	 * @see org.eclipse.pop.ssme.compilation.Scenario
	 * @generated
	 */
	EClass getScenario();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.pop.ssme.compilation.Scenario#getElements <em>Elements</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Elements</em>'.
	 * @see org.eclipse.pop.ssme.compilation.Scenario#getElements()
	 * @see #getScenario()
	 * @generated
	 */
	EReference getScenario_Elements();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.pop.ssme.compilation.Scenario#getDescription <em>Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Description</em>'.
	 * @see org.eclipse.pop.ssme.compilation.Scenario#getDescription()
	 * @see #getScenario()
	 * @generated
	 */
	EAttribute getScenario_Description();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.pop.ssme.compilation.Scenario#isDisplayWarnings <em>Display Warnings</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Display Warnings</em>'.
	 * @see org.eclipse.pop.ssme.compilation.Scenario#isDisplayWarnings()
	 * @see #getScenario()
	 * @generated
	 */
	EAttribute getScenario_DisplayWarnings();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.compilation.Functionality <em>Functionality</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Functionality</em>'.
	 * @see org.eclipse.pop.ssme.compilation.Functionality
	 * @generated
	 */
	EClass getFunctionality();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.pop.ssme.compilation.Functionality#getKind <em>Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Kind</em>'.
	 * @see org.eclipse.pop.ssme.compilation.Functionality#getKind()
	 * @see #getFunctionality()
	 * @generated
	 */
	EAttribute getFunctionality_Kind();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.compilation.Generator <em>Generator</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Generator</em>'.
	 * @see org.eclipse.pop.ssme.compilation.Generator
	 * @generated
	 */
	EClass getGenerator();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.pop.ssme.compilation.Generator#getKind <em>Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Kind</em>'.
	 * @see org.eclipse.pop.ssme.compilation.Generator#getKind()
	 * @see #getGenerator()
	 * @generated
	 */
	EAttribute getGenerator_Kind();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.compilation.ScenarioItem <em>Scenario Item</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Scenario Item</em>'.
	 * @see org.eclipse.pop.ssme.compilation.ScenarioItem
	 * @generated
	 */
	EClass getScenarioItem();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.pop.ssme.compilation.GeneratorKind <em>Generator Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Generator Kind</em>'.
	 * @see org.eclipse.pop.ssme.compilation.GeneratorKind
	 * @generated
	 */
	EEnum getGeneratorKind();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.pop.ssme.compilation.FunctionalityKind <em>Functionality Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Functionality Kind</em>'.
	 * @see org.eclipse.pop.ssme.compilation.FunctionalityKind
	 * @generated
	 */
	EEnum getFunctionalityKind();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	SsmeCompFactory getSsmeCompFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link org.eclipse.pop.ssme.compilation.impl.ScenarioImpl <em>Scenario</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.pop.ssme.compilation.impl.ScenarioImpl
		 * @see org.eclipse.pop.ssme.compilation.impl.SsmeCompPackageImpl#getScenario()
		 * @generated
		 */
		EClass SCENARIO = eINSTANCE.getScenario();

		/**
		 * The meta object literal for the '<em><b>Elements</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SCENARIO__ELEMENTS = eINSTANCE.getScenario_Elements();

		/**
		 * The meta object literal for the '<em><b>Description</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SCENARIO__DESCRIPTION = eINSTANCE.getScenario_Description();

		/**
		 * The meta object literal for the '<em><b>Display Warnings</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SCENARIO__DISPLAY_WARNINGS = eINSTANCE.getScenario_DisplayWarnings();

		/**
		 * The meta object literal for the '{@link org.eclipse.pop.ssme.compilation.impl.FunctionalityImpl <em>Functionality</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.pop.ssme.compilation.impl.FunctionalityImpl
		 * @see org.eclipse.pop.ssme.compilation.impl.SsmeCompPackageImpl#getFunctionality()
		 * @generated
		 */
		EClass FUNCTIONALITY = eINSTANCE.getFunctionality();

		/**
		 * The meta object literal for the '<em><b>Kind</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FUNCTIONALITY__KIND = eINSTANCE.getFunctionality_Kind();

		/**
		 * The meta object literal for the '{@link org.eclipse.pop.ssme.compilation.impl.GeneratorImpl <em>Generator</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.pop.ssme.compilation.impl.GeneratorImpl
		 * @see org.eclipse.pop.ssme.compilation.impl.SsmeCompPackageImpl#getGenerator()
		 * @generated
		 */
		EClass GENERATOR = eINSTANCE.getGenerator();

		/**
		 * The meta object literal for the '<em><b>Kind</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute GENERATOR__KIND = eINSTANCE.getGenerator_Kind();

		/**
		 * The meta object literal for the '{@link org.eclipse.pop.ssme.compilation.impl.ScenarioItemImpl <em>Scenario Item</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.pop.ssme.compilation.impl.ScenarioItemImpl
		 * @see org.eclipse.pop.ssme.compilation.impl.SsmeCompPackageImpl#getScenarioItem()
		 * @generated
		 */
		EClass SCENARIO_ITEM = eINSTANCE.getScenarioItem();

		/**
		 * The meta object literal for the '{@link org.eclipse.pop.ssme.compilation.GeneratorKind <em>Generator Kind</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.pop.ssme.compilation.GeneratorKind
		 * @see org.eclipse.pop.ssme.compilation.impl.SsmeCompPackageImpl#getGeneratorKind()
		 * @generated
		 */
		EEnum GENERATOR_KIND = eINSTANCE.getGeneratorKind();

		/**
		 * The meta object literal for the '{@link org.eclipse.pop.ssme.compilation.FunctionalityKind <em>Functionality Kind</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.pop.ssme.compilation.FunctionalityKind
		 * @see org.eclipse.pop.ssme.compilation.impl.SsmeCompPackageImpl#getFunctionalityKind()
		 * @generated
		 */
		EEnum FUNCTIONALITY_KIND = eINSTANCE.getFunctionalityKind();

	}

} //SsmeCompPackage
