/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.compilation.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.impl.EPackageImpl;
import org.eclipse.pop.ssme.compilation.Functionality;
import org.eclipse.pop.ssme.compilation.FunctionalityKind;
import org.eclipse.pop.ssme.compilation.Generator;
import org.eclipse.pop.ssme.compilation.GeneratorKind;
import org.eclipse.pop.ssme.compilation.Scenario;
import org.eclipse.pop.ssme.compilation.ScenarioItem;
import org.eclipse.pop.ssme.compilation.SsmeCompFactory;
import org.eclipse.pop.ssme.compilation.SsmeCompPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class SsmeCompPackageImpl extends EPackageImpl implements SsmeCompPackage {
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass scenarioEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass functionalityEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass generatorEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass scenarioItemEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum generatorKindEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum functionalityKindEEnum = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see org.eclipse.pop.ssme.compilation.SsmeCompPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private SsmeCompPackageImpl() {
		super(eNS_URI, SsmeCompFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model, and for any others upon which it depends.
	 * 
	 * <p>This method is used to initialize {@link SsmeCompPackage#eINSTANCE} when that field is accessed.
	 * Clients should not invoke it directly. Instead, they should simply access that field to obtain the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static SsmeCompPackage init() {
		if (isInited) return (SsmeCompPackage)EPackage.Registry.INSTANCE.getEPackage(SsmeCompPackage.eNS_URI);

		// Obtain or create and register package
		SsmeCompPackageImpl theSsmeCompPackage = (SsmeCompPackageImpl)(EPackage.Registry.INSTANCE.get(eNS_URI) instanceof SsmeCompPackageImpl ? EPackage.Registry.INSTANCE.get(eNS_URI) : new SsmeCompPackageImpl());

		isInited = true;

		// Create package meta-data objects
		theSsmeCompPackage.createPackageContents();

		// Initialize created meta-data
		theSsmeCompPackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theSsmeCompPackage.freeze();

  
		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(SsmeCompPackage.eNS_URI, theSsmeCompPackage);
		return theSsmeCompPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getScenario() {
		return scenarioEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getScenario_Elements() {
		return (EReference)scenarioEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getScenario_Description() {
		return (EAttribute)scenarioEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getScenario_DisplayWarnings() {
		return (EAttribute)scenarioEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getFunctionality() {
		return functionalityEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getFunctionality_Kind() {
		return (EAttribute)functionalityEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getGenerator() {
		return generatorEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getGenerator_Kind() {
		return (EAttribute)generatorEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getScenarioItem() {
		return scenarioItemEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getGeneratorKind() {
		return generatorKindEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getFunctionalityKind() {
		return functionalityKindEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SsmeCompFactory getSsmeCompFactory() {
		return (SsmeCompFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		scenarioEClass = createEClass(SCENARIO);
		createEReference(scenarioEClass, SCENARIO__ELEMENTS);
		createEAttribute(scenarioEClass, SCENARIO__DESCRIPTION);
		createEAttribute(scenarioEClass, SCENARIO__DISPLAY_WARNINGS);

		functionalityEClass = createEClass(FUNCTIONALITY);
		createEAttribute(functionalityEClass, FUNCTIONALITY__KIND);

		generatorEClass = createEClass(GENERATOR);
		createEAttribute(generatorEClass, GENERATOR__KIND);

		scenarioItemEClass = createEClass(SCENARIO_ITEM);

		// Create enums
		generatorKindEEnum = createEEnum(GENERATOR_KIND);
		functionalityKindEEnum = createEEnum(FUNCTIONALITY_KIND);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Create type parameters

		// Set bounds for type parameters

		// Add supertypes to classes
		functionalityEClass.getESuperTypes().add(this.getScenarioItem());
		generatorEClass.getESuperTypes().add(this.getScenarioItem());

		// Initialize classes and features; add operations and parameters
		initEClass(scenarioEClass, Scenario.class, "Scenario", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getScenario_Elements(), this.getScenarioItem(), null, "elements", null, 1, -1, Scenario.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getScenario_Description(), ecorePackage.getEString(), "description", null, 1, 1, Scenario.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getScenario_DisplayWarnings(), ecorePackage.getEBoolean(), "displayWarnings", "false", 0, 1, Scenario.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(functionalityEClass, Functionality.class, "Functionality", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getFunctionality_Kind(), this.getFunctionalityKind(), "kind", null, 1, 1, Functionality.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(generatorEClass, Generator.class, "Generator", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getGenerator_Kind(), this.getGeneratorKind(), "kind", null, 1, 1, Generator.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(scenarioItemEClass, ScenarioItem.class, "ScenarioItem", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		// Initialize enums and add enum literals
		initEEnum(generatorKindEEnum, GeneratorKind.class, "GeneratorKind");
		addEEnumLiteral(generatorKindEEnum, GeneratorKind.SIGNAL_LITERAL);
		addEEnumLiteral(generatorKindEEnum, GeneratorKind.SIGNAL_LIS_LITERAL);
		addEEnumLiteral(generatorKindEEnum, GeneratorKind.SIGNAL_TRA_LITERAL);
		addEEnumLiteral(generatorKindEEnum, GeneratorKind.SSME_LITERAL);
		addEEnumLiteral(generatorKindEEnum, GeneratorKind.SIGNAL_ABSTRACTION_LITERAL);
		addEEnumLiteral(generatorKindEEnum, GeneratorKind.SIGALI_LITERAL);
		addEEnumLiteral(generatorKindEEnum, GeneratorKind.CANSI_LITERAL);
		addEEnumLiteral(generatorKindEEnum, GeneratorKind.CPP_LITERAL);
		addEEnumLiteral(generatorKindEEnum, GeneratorKind.JAVA_LITERAL);
		addEEnumLiteral(generatorKindEEnum, GeneratorKind.PROFILING_LITERAL);
		addEEnumLiteral(generatorKindEEnum, GeneratorKind.LUSTRE_LITERAL);
		addEEnumLiteral(generatorKindEEnum, GeneratorKind.SYNDEX_LITERAL);

		initEEnum(functionalityKindEEnum, FunctionalityKind.class, "FunctionalityKind");
		addEEnumLiteral(functionalityKindEEnum, FunctionalityKind.RETIMING_LITERAL);
		addEEnumLiteral(functionalityKindEEnum, FunctionalityKind.BOOLEAN2_EVENTS_LITERAL);
		addEEnumLiteral(functionalityKindEEnum, FunctionalityKind.SIGNAL_UNIFICATIONS_LITERAL);
		addEEnumLiteral(functionalityKindEEnum, FunctionalityKind.CLOCK_CALCULUS_LITERAL);
		addEEnumLiteral(functionalityKindEEnum, FunctionalityKind.EVENTS2_BOOLEAN_LITERAL);
		addEEnumLiteral(functionalityKindEEnum, FunctionalityKind.ABSTRACTION_LITERAL);
		addEEnumLiteral(functionalityKindEEnum, FunctionalityKind.CLUSTERING_LITERAL);
		addEEnumLiteral(functionalityKindEEnum, FunctionalityKind.SEQUENTIALIZING_LITERAL);
		addEEnumLiteral(functionalityKindEEnum, FunctionalityKind.FLATTENING_LITERAL);

		// Create resource
		createResource(eNS_URI);

		// Create annotations
		// http://www.topcased.org/uuid
		createUuidAnnotations();
	}

	/**
	 * Initializes the annotations for <b>http://www.topcased.org/uuid</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createUuidAnnotations() {
		String source = "http://www.topcased.org/uuid";		
		addAnnotation
		  (this, 
		   source, 
		   new String[] {
			 "uuid", "_26vDkMM9EduFJvhn52JvCw"
		   });		
		addAnnotation
		  (scenarioEClass, 
		   source, 
		   new String[] {
			 "uuid", "_26vDkcM9EduFJvhn52JvCw"
		   });		
		addAnnotation
		  (getScenario_Elements(), 
		   source, 
		   new String[] {
			 "uuid", "_Ao3VwsM-EduFJvhn52JvCw"
		   });		
		addAnnotation
		  (getScenario_Description(), 
		   source, 
		   new String[] {
			 "uuid", "_IvY0gxj_Edy0-YMMPKJZWQ"
		   });			
		addAnnotation
		  (functionalityEClass, 
		   source, 
		   new String[] {
			 "uuid", "_26vDksM9EduFJvhn52JvCw"
		   });		
		addAnnotation
		  (getFunctionality_Kind(), 
		   source, 
		   new String[] {
			 "uuid", "_WxFxJMM-EduFJvhn52JvCw"
		   });		
		addAnnotation
		  (generatorEClass, 
		   source, 
		   new String[] {
			 "uuid", "_2640kMM9EduFJvhn52JvCw"
		   });		
		addAnnotation
		  (getGenerator_Kind(), 
		   source, 
		   new String[] {
			 "uuid", "_TLwCJcM-EduFJvhn52JvCw"
		   });		
		addAnnotation
		  (scenarioItemEClass, 
		   source, 
		   new String[] {
			 "uuid", "__FeQZMM9EduFJvhn52JvCw"
		   });		
		addAnnotation
		  (generatorKindEEnum, 
		   source, 
		   new String[] {
			 "uuid", "_fu9rGMM-EduFJvhn52JvCw"
		   });		
		addAnnotation
		  (generatorKindEEnum.getELiterals().get(0), 
		   source, 
		   new String[] {
			 "uuid", "_fu9rGcM-EduFJvhn52JvCw"
		   });			
		addAnnotation
		  (generatorKindEEnum.getELiterals().get(3), 
		   source, 
		   new String[] {
			 "uuid", "_C_xYohj6Edyp0-eFBeYalQ"
		   });			
		addAnnotation
		  (generatorKindEEnum.getELiterals().get(4), 
		   source, 
		   new String[] {
			 "uuid", "_2xo8isM-EduFJvhn52JvCw"
		   });			
		addAnnotation
		  (generatorKindEEnum.getELiterals().get(5), 
		   source, 
		   new String[] {
			 "uuid", "_2xo8jMM-EduFJvhn52JvCw"
		   });			
		addAnnotation
		  (generatorKindEEnum.getELiterals().get(6), 
		   source, 
		   new String[] {
			 "uuid", "_2xytgMM-EduFJvhn52JvCw"
		   });			
		addAnnotation
		  (generatorKindEEnum.getELiterals().get(7), 
		   source, 
		   new String[] {
			 "uuid", "_2x8egMM-EduFJvhn52JvCw"
		   });			
		addAnnotation
		  (generatorKindEEnum.getELiterals().get(8), 
		   source, 
		   new String[] {
			 "uuid", "_2x8egcM-EduFJvhn52JvCw"
		   });			
		addAnnotation
		  (generatorKindEEnum.getELiterals().get(9), 
		   source, 
		   new String[] {
			 "uuid", "_2yFocMM-EduFJvhn52JvCw"
		   });			
		addAnnotation
		  (generatorKindEEnum.getELiterals().get(10), 
		   source, 
		   new String[] {
			 "uuid", "_QecFcRgDEdyHFcLr3WKLWw"
		   });			
		addAnnotation
		  (generatorKindEEnum.getELiterals().get(11), 
		   source, 
		   new String[] {
			 "uuid", "_fBdaNHC8Edy8o4swpAVO6g"
		   });			
		addAnnotation
		  (functionalityKindEEnum, 
		   source, 
		   new String[] {
			 "uuid", "_blv9kcM_EduFJvhn52JvCw"
		   });		
		addAnnotation
		  (functionalityKindEEnum.getELiterals().get(0), 
		   source, 
		   new String[] {
			 "uuid", "_blv9ksM_EduFJvhn52JvCw"
		   });			
		addAnnotation
		  (functionalityKindEEnum.getELiterals().get(1), 
		   source, 
		   new String[] {
			 "uuid", "_bl5ugMM_EduFJvhn52JvCw"
		   });			
		addAnnotation
		  (functionalityKindEEnum.getELiterals().get(2), 
		   source, 
		   new String[] {
			 "uuid", "_bmC4cMM_EduFJvhn52JvCw"
		   });			
		addAnnotation
		  (functionalityKindEEnum.getELiterals().get(3), 
		   source, 
		   new String[] {
			 "uuid", "_bmMpcMM_EduFJvhn52JvCw"
		   });			
		addAnnotation
		  (functionalityKindEEnum.getELiterals().get(4), 
		   source, 
		   new String[] {
			 "uuid", "_bmVzYMM_EduFJvhn52JvCw"
		   });			
		addAnnotation
		  (functionalityKindEEnum.getELiterals().get(5), 
		   source, 
		   new String[] {
			 "uuid", "_bmfkYMM_EduFJvhn52JvCw"
		   });			
		addAnnotation
		  (functionalityKindEEnum.getELiterals().get(6), 
		   source, 
		   new String[] {
			 "uuid", "_bmpVYMM_EduFJvhn52JvCw"
		   });			
		addAnnotation
		  (functionalityKindEEnum.getELiterals().get(7), 
		   source, 
		   new String[] {
			 "uuid", "_bmyfUMM_EduFJvhn52JvCw"
		   });			
		addAnnotation
		  (functionalityKindEEnum.getELiterals().get(8), 
		   source, 
		   new String[] {
			 "uuid", "_bm8QUMM_EduFJvhn52JvCw"
		   });	
	}

} //SsmeCompPackageImpl
