/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.provider;


import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.pop.ssme.Bounds;
import org.eclipse.pop.ssme.SsmeFactory;
import org.eclipse.pop.ssme.SsmePackage;

/**
 * This is the item provider adapter for a {@link org.eclipse.pop.ssme.Bounds} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class BoundsItemProvider
	extends SignalElementItemProvider {
	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BoundsItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addLowerBoundPropertyDescriptor(object);
			addUpperBoundPropertyDescriptor(object);
			addStepPropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Lower Bound feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addLowerBoundPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_Bounds_lowerBound_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_Bounds_lowerBound_feature", "_UI_Bounds_type"),
				 SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 true,
				 false,
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Upper Bound feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addUpperBoundPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_Bounds_upperBound_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_Bounds_upperBound_feature", "_UI_Bounds_type"),
				 SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 true,
				 false,
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Step feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addStepPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_Bounds_step_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_Bounds_step_feature", "_UI_Bounds_type"),
				 SsmePackage.eINSTANCE.getBounds_Step(),
				 true,
				 false,
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This specifies how to implement {@link #getChildren} and is used to deduce an appropriate feature for an
	 * {@link org.eclipse.emf.edit.command.AddCommand}, {@link org.eclipse.emf.edit.command.RemoveCommand} or
	 * {@link org.eclipse.emf.edit.command.MoveCommand} in {@link #createCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
		if (childrenFeatures == null) {
			super.getChildrenFeatures(object);
			childrenFeatures.add(SsmePackage.eINSTANCE.getBounds_LowerBound());
			childrenFeatures.add(SsmePackage.eINSTANCE.getBounds_UpperBound());
			childrenFeatures.add(SsmePackage.eINSTANCE.getBounds_Step());
		}
		return childrenFeatures;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EStructuralFeature getChildFeature(Object object, Object child) {
		// Check the type of the specified child object and return the proper feature to use for
		// adding (see {@link AddCommand}) it as a child.

		return super.getChildFeature(object, child);
	}

	/**
	 * This returns Bounds.gif.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object getImage(Object object) {
		return overlayImage(object, getResourceLocator().getImage("full/obj16/Bounds"));
	}

	/**
	 * This returns the label text for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getText(Object object) {
		return getString("_UI_Bounds_type");
	}

	/**
	 * This handles model notifications by calling {@link #updateChildren} to update any cached
	 * children and by creating a viewer notification, which it passes to {@link #fireNotifyChanged}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void notifyChanged(Notification notification) {
		updateChildren(notification);

		switch (notification.getFeatureID(Bounds.class)) {
			case SsmePackage.BOUNDS__LOWER_BOUND:
			case SsmePackage.BOUNDS__UPPER_BOUND:
			case SsmePackage.BOUNDS__STEP:
				fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), true, false));
				return;
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds {@link org.eclipse.emf.edit.command.CommandParameter}s describing the children
	 * that can be created under this object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createAfter()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createAnd()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createArrayElem()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createArrayElementsEnumeration()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createArrayProduct()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createArrayRestructuration()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createAssertSignal()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createCartesianProduct()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createCell()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createClock()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createClockDifference()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createClockProduct()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createClockUnion()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createComplexConstructor()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createConcatenation()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createConstantCharacter()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createConstantDoubleReal()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createConstantEnum()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createConstantInteger()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createConstantLogical()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createConstantReal()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createConversion()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createCount()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createDefault()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createDelay()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createDiv()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createElemDefinitionEnumeration()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createEqualEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createFieldAccess()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createFrom()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createGreater()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createGreaterOrEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createIdentifier()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createIfThenElse()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createIndex()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createLess()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createLessLessEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createLessOrEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createListFlows()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createMinus()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createModulo()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createNot()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createNotEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createNullClock()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createOr()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createPlus()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createPower()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createPreviousIterationRef()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createProcessCall()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createProcessExpansion()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createProduct()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createRecover()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createRepetition()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createSequentialDefinition()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createStateVariableValue()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createStringValue()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createTransposition()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createUnaryMinus()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createUnaryPlus()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createUnaryWhen()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createVar()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createWhen()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createWindow()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_LowerBound(),
				 SsmeFactory.eINSTANCE.createXor()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createAfter()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createAnd()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createArrayElem()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createArrayElementsEnumeration()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createArrayProduct()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createArrayRestructuration()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createAssertSignal()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createCartesianProduct()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createCell()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createClock()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createClockDifference()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createClockProduct()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createClockUnion()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createComplexConstructor()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createConcatenation()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createConstantCharacter()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createConstantDoubleReal()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createConstantEnum()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createConstantInteger()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createConstantLogical()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createConstantReal()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createConversion()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createCount()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createDefault()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createDelay()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createDiv()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createElemDefinitionEnumeration()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createEqualEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createFieldAccess()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createFrom()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createGreater()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createGreaterOrEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createIdentifier()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createIfThenElse()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createIndex()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createLess()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createLessLessEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createLessOrEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createListFlows()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createMinus()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createModulo()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createNot()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createNotEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createNullClock()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createOr()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createPlus()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createPower()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createPreviousIterationRef()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createProcessCall()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createProcessExpansion()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createProduct()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createRecover()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createRepetition()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createSequentialDefinition()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createStateVariableValue()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createStringValue()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createTransposition()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createUnaryMinus()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createUnaryPlus()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createUnaryWhen()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createVar()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createWhen()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createWindow()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_UpperBound(),
				 SsmeFactory.eINSTANCE.createXor()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createAfter()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createAnd()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createArrayElem()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createArrayElementsEnumeration()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createArrayProduct()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createArrayRestructuration()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createAssertSignal()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createCartesianProduct()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createCell()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createClock()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createClockDifference()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createClockProduct()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createClockUnion()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createComplexConstructor()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createConcatenation()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createConstantCharacter()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createConstantDoubleReal()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createConstantEnum()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createConstantInteger()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createConstantLogical()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createConstantReal()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createConversion()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createCount()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createDefault()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createDelay()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createDiv()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createElemDefinitionEnumeration()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createEqualEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createFieldAccess()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createFrom()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createGreater()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createGreaterOrEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createIdentifier()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createIfThenElse()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createIndex()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createLess()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createLessLessEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createLessOrEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createListFlows()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createMinus()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createModulo()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createNot()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createNotEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createNullClock()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createOr()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createPlus()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createPower()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createPreviousIterationRef()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createProcessCall()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createProcessExpansion()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createProduct()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createRecover()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createRepetition()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createSequentialDefinition()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createStateVariableValue()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createStringValue()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createTransposition()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createUnaryMinus()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createUnaryPlus()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createUnaryWhen()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createVar()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createWhen()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createWindow()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getBounds_Step(),
				 SsmeFactory.eINSTANCE.createXor()));
	}

	/**
	 * This returns the label text for {@link org.eclipse.emf.edit.command.CreateChildCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getCreateChildText(Object owner, Object feature, Object child, Collection<?> selection) {
		Object childFeature = feature;
		Object childObject = child;

		boolean qualify =
			childFeature == SsmePackage.eINSTANCE.getSignalElement_CommentPre() ||
			childFeature == SsmePackage.eINSTANCE.getSignalElement_CommentPost() ||
			childFeature == SsmePackage.eINSTANCE.getBounds_LowerBound() ||
			childFeature == SsmePackage.eINSTANCE.getBounds_UpperBound() ||
			childFeature == SsmePackage.eINSTANCE.getBounds_Step();

		if (qualify) {
			return getString
				("_UI_CreateChild_text2",
				 new Object[] { getTypeText(childObject), getFeatureText(childFeature), getTypeText(owner) });
		}
		return super.getCreateChildText(owner, feature, child, selection);
	}

}
