/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.provider;


import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.pop.ssme.RestrictionProcess;
import org.eclipse.pop.ssme.SsmeFactory;
import org.eclipse.pop.ssme.SsmePackage;

/**
 * This is the item provider adapter for a {@link org.eclipse.pop.ssme.RestrictionProcess} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class RestrictionProcessItemProvider
	extends SignalElementItemProvider {
	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RestrictionProcessItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addExprProcessPropertyDescriptor(object);
			addListDeclarationsPropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Expr Process feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addExprProcessPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_RestrictionProcess_exprProcess_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_RestrictionProcess_exprProcess_feature", "_UI_RestrictionProcess_type"),
				 SsmePackage.eINSTANCE.getRestrictionProcess_ExprProcess(),
				 true,
				 false,
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the List Declarations feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addListDeclarationsPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_RestrictionProcess_listDeclarations_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_RestrictionProcess_listDeclarations_feature", "_UI_RestrictionProcess_type"),
				 SsmePackage.eINSTANCE.getRestrictionProcess_ListDeclarations(),
				 true,
				 false,
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This specifies how to implement {@link #getChildren} and is used to deduce an appropriate feature for an
	 * {@link org.eclipse.emf.edit.command.AddCommand}, {@link org.eclipse.emf.edit.command.RemoveCommand} or
	 * {@link org.eclipse.emf.edit.command.MoveCommand} in {@link #createCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
		if (childrenFeatures == null) {
			super.getChildrenFeatures(object);
			childrenFeatures.add(SsmePackage.eINSTANCE.getRestrictionProcess_ExprProcess());
			childrenFeatures.add(SsmePackage.eINSTANCE.getRestrictionProcess_ListDeclarations());
		}
		return childrenFeatures;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EStructuralFeature getChildFeature(Object object, Object child) {
		// Check the type of the specified child object and return the proper feature to use for
		// adding (see {@link AddCommand}) it as a child.

		return super.getChildFeature(object, child);
	}

	/**
	 * This returns RestrictionProcess.gif.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object getImage(Object object) {
		return overlayImage(object, getResourceLocator().getImage("full/obj16/RestrictionProcess"));
	}

	/**
	 * This returns the label text for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getText(Object object) {
		return getString("_UI_RestrictionProcess_type");
	}

	/**
	 * This handles model notifications by calling {@link #updateChildren} to update any cached
	 * children and by creating a viewer notification, which it passes to {@link #fireNotifyChanged}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void notifyChanged(Notification notification) {
		updateChildren(notification);

		switch (notification.getFeatureID(RestrictionProcess.class)) {
			case SsmePackage.RESTRICTION_PROCESS__EXPR_PROCESS:
			case SsmePackage.RESTRICTION_PROCESS__LIST_DECLARATIONS:
				fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), true, false));
				return;
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds {@link org.eclipse.emf.edit.command.CommandParameter}s describing the children
	 * that can be created under this object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getRestrictionProcess_ExprProcess(),
				 SsmeFactory.eINSTANCE.createArrayProcess()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getRestrictionProcess_ExprProcess(),
				 SsmeFactory.eINSTANCE.createAssertProcess()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getRestrictionProcess_ExprProcess(),
				 SsmeFactory.eINSTANCE.createAssertSignal()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getRestrictionProcess_ExprProcess(),
				 SsmeFactory.eINSTANCE.createCaseProcess()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getRestrictionProcess_ExprProcess(),
				 SsmeFactory.eINSTANCE.createClockEquality()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getRestrictionProcess_ExprProcess(),
				 SsmeFactory.eINSTANCE.createClockExclusiveRelation()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getRestrictionProcess_ExprProcess(),
				 SsmeFactory.eINSTANCE.createClockInfRelation()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getRestrictionProcess_ExprProcess(),
				 SsmeFactory.eINSTANCE.createClockSupRelation()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getRestrictionProcess_ExprProcess(),
				 SsmeFactory.eINSTANCE.createComposition()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getRestrictionProcess_ExprProcess(),
				 SsmeFactory.eINSTANCE.createConditionedDependence()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getRestrictionProcess_ExprProcess(),
				 SsmeFactory.eINSTANCE.createControlledProcess()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getRestrictionProcess_ExprProcess(),
				 SsmeFactory.eINSTANCE.createIdentityEquation()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getRestrictionProcess_ExprProcess(),
				 SsmeFactory.eINSTANCE.createIterationProcess()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getRestrictionProcess_ExprProcess(),
				 SsmeFactory.eINSTANCE.createLabelledProcess()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getRestrictionProcess_ExprProcess(),
				 SsmeFactory.eINSTANCE.createMasking()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getRestrictionProcess_ExprProcess(),
				 SsmeFactory.eINSTANCE.createNullProc()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getRestrictionProcess_ExprProcess(),
				 SsmeFactory.eINSTANCE.createProcessCall()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getRestrictionProcess_ExprProcess(),
				 SsmeFactory.eINSTANCE.createProcessExpansion()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getRestrictionProcess_ExprProcess(),
				 SsmeFactory.eINSTANCE.createRestrictionProcess()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getRestrictionProcess_ExprProcess(),
				 SsmeFactory.eINSTANCE.createSignalsDefinition()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getRestrictionProcess_ExprProcess(),
				 SsmeFactory.eINSTANCE.createSignalsPartialDefaultDefinition()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getRestrictionProcess_ExprProcess(),
				 SsmeFactory.eINSTANCE.createSignalsPartialDefinition()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getRestrictionProcess_ExprProcess(),
				 SsmeFactory.eINSTANCE.createUnconditionedDependences()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getRestrictionProcess_ListDeclarations(),
				 SsmeFactory.eINSTANCE.createConstantsDeclaration()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getRestrictionProcess_ListDeclarations(),
				 SsmeFactory.eINSTANCE.createExternalReferences()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getRestrictionProcess_ListDeclarations(),
				 SsmeFactory.eINSTANCE.createFormalProcess()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getRestrictionProcess_ListDeclarations(),
				 SsmeFactory.eINSTANCE.createLabels()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getRestrictionProcess_ListDeclarations(),
				 SsmeFactory.eINSTANCE.createModulesImport()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getRestrictionProcess_ListDeclarations(),
				 SsmeFactory.eINSTANCE.createOperatorModel()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getRestrictionProcess_ListDeclarations(),
				 SsmeFactory.eINSTANCE.createProcessModel()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getRestrictionProcess_ListDeclarations(),
				 SsmeFactory.eINSTANCE.createSharedVariablesDeclaration()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getRestrictionProcess_ListDeclarations(),
				 SsmeFactory.eINSTANCE.createSignalsDeclaration()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getRestrictionProcess_ListDeclarations(),
				 SsmeFactory.eINSTANCE.createStateVariablesDeclaration()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getRestrictionProcess_ListDeclarations(),
				 SsmeFactory.eINSTANCE.createTypesDeclaration()));
	}

	/**
	 * This returns the label text for {@link org.eclipse.emf.edit.command.CreateChildCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getCreateChildText(Object owner, Object feature, Object child, Collection<?> selection) {
		Object childFeature = feature;
		Object childObject = child;

		boolean qualify =
			childFeature == SsmePackage.eINSTANCE.getSignalElement_CommentPre() ||
			childFeature == SsmePackage.eINSTANCE.getSignalElement_CommentPost();

		if (qualify) {
			return getString
				("_UI_CreateChild_text2",
				 new Object[] { getTypeText(childObject), getFeatureText(childFeature), getTypeText(owner) });
		}
		return super.getCreateChildText(owner, feature, child, selection);
	}

}
