/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.provider;


import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.pop.ssme.SignalsDefinition;
import org.eclipse.pop.ssme.SsmeFactory;
import org.eclipse.pop.ssme.SsmePackage;

/**
 * This is the item provider adapter for a {@link org.eclipse.pop.ssme.SignalsDefinition} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class SignalsDefinitionItemProvider
	extends SignalElementItemProvider {
	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SignalsDefinitionItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addExprSignalLeftPropertyDescriptor(object);
			addExprSignalRightPropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Expr Signal Left feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addExprSignalLeftPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_SignalsDefinition_exprSignalLeft_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_SignalsDefinition_exprSignalLeft_feature", "_UI_SignalsDefinition_type"),
				 SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 true,
				 false,
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Expr Signal Right feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addExprSignalRightPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_SignalsDefinition_exprSignalRight_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_SignalsDefinition_exprSignalRight_feature", "_UI_SignalsDefinition_type"),
				 SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 true,
				 false,
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This specifies how to implement {@link #getChildren} and is used to deduce an appropriate feature for an
	 * {@link org.eclipse.emf.edit.command.AddCommand}, {@link org.eclipse.emf.edit.command.RemoveCommand} or
	 * {@link org.eclipse.emf.edit.command.MoveCommand} in {@link #createCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
		if (childrenFeatures == null) {
			super.getChildrenFeatures(object);
			childrenFeatures.add(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft());
			childrenFeatures.add(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight());
		}
		return childrenFeatures;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EStructuralFeature getChildFeature(Object object, Object child) {
		// Check the type of the specified child object and return the proper feature to use for
		// adding (see {@link AddCommand}) it as a child.

		return super.getChildFeature(object, child);
	}

	/**
	 * This returns SignalsDefinition.gif.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object getImage(Object object) {
		return overlayImage(object, getResourceLocator().getImage("full/obj16/SignalsDefinition"));
	}

	/**
	 * This returns the label text for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getText(Object object) {
		return getString("_UI_SignalsDefinition_type");
	}

	/**
	 * This handles model notifications by calling {@link #updateChildren} to update any cached
	 * children and by creating a viewer notification, which it passes to {@link #fireNotifyChanged}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void notifyChanged(Notification notification) {
		updateChildren(notification);

		switch (notification.getFeatureID(SignalsDefinition.class)) {
			case SsmePackage.SIGNALS_DEFINITION__EXPR_SIGNAL_LEFT:
			case SsmePackage.SIGNALS_DEFINITION__EXPR_SIGNAL_RIGHT:
				fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), true, false));
				return;
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds {@link org.eclipse.emf.edit.command.CommandParameter}s describing the children
	 * that can be created under this object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createAfter()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createAnd()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createArrayElem()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createArrayElementsEnumeration()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createArrayProduct()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createArrayRestructuration()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createAssertSignal()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createCartesianProduct()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createCell()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createClock()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createClockDifference()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createClockProduct()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createClockUnion()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createComplexConstructor()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createConcatenation()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createConstantCharacter()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createConstantDoubleReal()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createConstantEnum()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createConstantInteger()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createConstantLogical()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createConstantReal()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createConversion()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createCount()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createDefault()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createDelay()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createDiv()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createElemDefinitionEnumeration()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createEqualEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createFieldAccess()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createFrom()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createGreater()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createGreaterOrEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createIdentifier()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createIfThenElse()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createIndex()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createLess()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createLessLessEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createLessOrEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createListFlows()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createMinus()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createModulo()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createNot()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createNotEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createNullClock()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createOr()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createPlus()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createPower()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createPreviousIterationRef()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createProcessCall()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createProcessExpansion()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createProduct()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createRecover()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createRepetition()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createSequentialDefinition()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createStateVariableValue()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createStringValue()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createTransposition()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createUnaryMinus()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createUnaryPlus()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createUnaryWhen()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createVar()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createWhen()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createWindow()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft(),
				 SsmeFactory.eINSTANCE.createXor()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createAfter()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createAnd()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createArrayElem()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createArrayElementsEnumeration()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createArrayProduct()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createArrayRestructuration()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createAssertSignal()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createCartesianProduct()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createCell()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createClock()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createClockDifference()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createClockProduct()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createClockUnion()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createComplexConstructor()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createConcatenation()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createConstantCharacter()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createConstantDoubleReal()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createConstantEnum()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createConstantInteger()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createConstantLogical()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createConstantReal()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createConversion()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createCount()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createDefault()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createDelay()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createDiv()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createElemDefinitionEnumeration()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createEqualEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createFieldAccess()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createFrom()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createGreater()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createGreaterOrEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createIdentifier()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createIfThenElse()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createIndex()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createLess()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createLessLessEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createLessOrEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createListFlows()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createMinus()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createModulo()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createNot()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createNotEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createNullClock()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createOr()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createPlus()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createPower()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createPreviousIterationRef()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createProcessCall()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createProcessExpansion()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createProduct()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createRecover()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createRepetition()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createSequentialDefinition()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createStateVariableValue()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createStringValue()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createTransposition()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createUnaryMinus()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createUnaryPlus()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createUnaryWhen()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createVar()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createWhen()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createWindow()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight(),
				 SsmeFactory.eINSTANCE.createXor()));
	}

	/**
	 * This returns the label text for {@link org.eclipse.emf.edit.command.CreateChildCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getCreateChildText(Object owner, Object feature, Object child, Collection<?> selection) {
		Object childFeature = feature;
		Object childObject = child;

		boolean qualify =
			childFeature == SsmePackage.eINSTANCE.getSignalElement_CommentPre() ||
			childFeature == SsmePackage.eINSTANCE.getSignalElement_CommentPost() ||
			childFeature == SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalLeft() ||
			childFeature == SsmePackage.eINSTANCE.getSignalsDefinition_ExprSignalRight();

		if (qualify) {
			return getString
				("_UI_CreateChild_text2",
				 new Object[] { getTypeText(childObject), getFeatureText(childFeature), getTypeText(owner) });
		}
		return super.getCreateChildText(owner, feature, child, selection);
	}

}
