/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.polychrony;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

public enum ExclusiveClockLevelKind implements Enumerator {
	ONLY_SIGNAL_CLOCKS_LITERAL(0, "onlySignalClocks", "Only Signal clocks"), ACTION_P_LITERAL(1,
			"sigClocksAndExprClock", "Signal clocks & clocks referenced in expression"), ALL_CLOCKS_LITERAL(2,
			"allClocks", "All the clocks of the graph");
	
	public static final int								ONLY_SIGNAL_CLOCKS	= 0;
	public static final int								ACTION_P			= 1;
	public static final int								ALL_CLOCKS			= 2;
	
	private static final ExclusiveClockLevelKind[]		VALUES_ARRAY		= new ExclusiveClockLevelKind[] {
			ONLY_SIGNAL_CLOCKS_LITERAL, ACTION_P_LITERAL, ALL_CLOCKS_LITERAL, };
	
	public static final List<ExclusiveClockLevelKind>	VALUES				= Collections.unmodifiableList(Arrays
																					.asList(VALUES_ARRAY));
	
	public static ExclusiveClockLevelKind get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ExclusiveClockLevelKind result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}
	
	public static ExclusiveClockLevelKind getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ExclusiveClockLevelKind result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}
	
	public static ExclusiveClockLevelKind get(int value) {
		switch (value) {
			case ONLY_SIGNAL_CLOCKS:
				return ONLY_SIGNAL_CLOCKS_LITERAL;
			case ACTION_P:
				return ACTION_P_LITERAL;
			case ALL_CLOCKS:
				return ALL_CLOCKS_LITERAL;
			default:
				return ONLY_SIGNAL_CLOCKS_LITERAL;
		}
	}
	
	private final int		value;
	
	private final String	name;
	
	private final String	literal;
	
	/**
	 * @param value
	 * @param name
	 * @param literal
	 */
	private ExclusiveClockLevelKind(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.emf.common.util.Enumerator#getLiteral()
	 */
	public String getLiteral() {
		return literal;
	}
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.emf.common.util.Enumerator#getName()
	 */
	public String getName() {
		return name;
	}
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.emf.common.util.Enumerator#getValue()
	 */
	public int getValue() {
		return value;
	}
}
