/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.polychrony;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * Enumeration of all error code return by POP.ative part services
 */
public enum ExitStatus implements Enumerator {
	NO_ERROR_LITERAL(0, "NoError", "No Error"), OPTION_ERROR_LITERAL(-3, "OptionError", "Option error"),
	NO_ARGS_LITERAL(-2, "NoArgs", "Missing argument"), NO_FILE_LITERAL(-1, "NoFile", "Missing file argument"),
	INIT_ERROR_LITERAL(1, "InitError", "Error during the initialization (library not found,...)"),
	SYNTAX_ERROR_PROG_LITERAL(2, "SyntaxeErrorProg", "Syntax error in the program"), SYNTAX_ERROR_PARAM_LITERAL(3,
			"SyntaxeErrorParam", "Syntax error for the parameters"), SOLVING_REF_ERROR_LITERAL(4, "SolvingRefError",
			"Error during the solving reference step"), TYPE_ERROR_LITERAL(5, "TypeError", "Program not well typed"),
	CYCLE_LITERAL(6, "Cycle", "Program with cycles"), PROFILING_ERROR_LITERAL(7, "ProfilingError",
			"Error during the profiling functionality"), ABSTRACTION_ERROR_LITERAL(8, "AbstractionError",
			"Error during the abstraction functionality"), INTERNAL_ERROR_LITERAL(9999, "InternalError",
			"Error inside the native part compiler");
	
	public static final int					NO_ERROR			= 0;
	
	public static final int					OPTION_ERROR		= -3;
	public static final int					NO_ARGS				= -2;
	public static final int					NO_FILE				= -1;
	
	public static final int					INIT_ERROR			= 1;
	public static final int					SYNTAX_ERROR_PROG	= 2;
	public static final int					SYNTAX_ERROR_PARAM	= 3;
	public static final int					SOLVING_REF_ERROR	= 4;
	public static final int					TYPE_ERROR			= 5;
	public static final int					CYCLE				= 6;
	public static final int					PROFILING_ERROR		= 7;
	public static final int					ABSTRACTION_ERROR	= 8;
	public static final int					INTERNAL_ERROR		= 9999;
	
	private static final ExitStatus[]		VALUES_ARRAY		= new ExitStatus[] { NO_ERROR_LITERAL,
			OPTION_ERROR_LITERAL, NO_ARGS_LITERAL, NO_FILE_LITERAL, INIT_ERROR_LITERAL, SYNTAX_ERROR_PROG_LITERAL,
			SYNTAX_ERROR_PARAM_LITERAL, SOLVING_REF_ERROR_LITERAL, TYPE_ERROR_LITERAL, CYCLE_LITERAL,
			PROFILING_ERROR_LITERAL, ABSTRACTION_ERROR_LITERAL, INTERNAL_ERROR_LITERAL, };
	
	public static final List<ExitStatus>	VALUES				= Collections.unmodifiableList(Arrays
																		.asList(VALUES_ARRAY));
	
	public static ExitStatus get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ExitStatus result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}
	
	public static ExitStatus getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ExitStatus result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}
	
	public static ExitStatus get(int value) {
		switch (value) {
			case OPTION_ERROR:
				return OPTION_ERROR_LITERAL;
			case NO_ARGS:
				return NO_ARGS_LITERAL;
			case NO_FILE:
				return NO_FILE_LITERAL;
			case INIT_ERROR:
				return INIT_ERROR_LITERAL;
			case SYNTAX_ERROR_PROG:
				return SYNTAX_ERROR_PROG_LITERAL;
			case SYNTAX_ERROR_PARAM:
				return SYNTAX_ERROR_PARAM_LITERAL;
			case SOLVING_REF_ERROR:
				return SOLVING_REF_ERROR_LITERAL;
			case TYPE_ERROR:
				return TYPE_ERROR_LITERAL;
			case CYCLE:
				return CYCLE_LITERAL;
			case PROFILING_ERROR:
				return PROFILING_ERROR_LITERAL;
			case ABSTRACTION_ERROR:
				return ABSTRACTION_ERROR_LITERAL;
			case INTERNAL_ERROR:
				return INTERNAL_ERROR_LITERAL;
			default:
				return NO_ERROR_LITERAL;
		}
	}
	
	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private final int		value;
	
	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private final String	name;
	
	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private final String	literal;
	
	/**
	 * Only this class can construct instances.
	 * 
	 * @generated
	 */
	private ExitStatus(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}
	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public int getValue() {
		return value;
	}
	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String getName() {
		return name;
	}
	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String getLiteral() {
		return literal;
	}
	/**
	 * Returns the literal value of the enumerator, which is its string representation. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
}
