/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.polychrony;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

public enum IdentifierKind implements Enumerator {
	LOCAL_LITERAL(0, "local", "local"), PARAMETER_LITERAL(1, "parameter", "parameter"), INPUT_LITERAL(2, "input",
			"input"), OUTPUT_LITERAL(3, "output", "output");
	
	public static final int						LOCAL			= 0;
	public static final int						PARAMETER		= 1;
	public static final int						INPUT			= 2;
	public static final int						OUTPUT			= 3;
	
	private static final IdentifierKind[]		VALUES_ARRAY	= new IdentifierKind[] { LOCAL_LITERAL,
			PARAMETER_LITERAL, INPUT_LITERAL, OUTPUT_LITERAL,	};
	
	public static final List<IdentifierKind>	VALUES			= Collections.unmodifiableList(Arrays
																		.asList(VALUES_ARRAY));
	
	public static IdentifierKind get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			IdentifierKind result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}
	
	public static IdentifierKind getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			IdentifierKind result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}
	
	public static IdentifierKind get(int value) {
		switch (value) {
			case LOCAL:
				return LOCAL_LITERAL;
			case PARAMETER:
				return PARAMETER_LITERAL;
			case INPUT:
				return INPUT_LITERAL;
			case OUTPUT:
				return OUTPUT_LITERAL;
			default:
				return PARAMETER_LITERAL;
		}
	}
	
	private final int		value;
	
	private final String	name;
	
	private final String	literal;
	
	/**
	 * @param value
	 * @param name
	 * @param literal
	 */
	private IdentifierKind(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.emf.common.util.Enumerator#getLiteral()
	 */
	public String getLiteral() {
		return literal;
	}
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.emf.common.util.Enumerator#getName()
	 */
	public String getName() {
		return name;
	}
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.emf.common.util.Enumerator#getValue()
	 */
	public int getValue() {
		return value;
	}
}
