/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.polychrony;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

public enum LanguageCode implements Enumerator {
	UNDEFINED_LITERAL(-1, "undefined", "undefined"), C_CODE_LITERAL(0, "C_CODE", "C_CODE"), CPP_CODE_LITERAL(1,
			"CPP_CODE", "CPP_CODE"), JAVA_CODE_LITERAL(2, "JAVA_CODE", "JAVA_CODE");
	
	public static final int					UNDEFINED		= -1;
	public static final int					C_CODE			= 0;
	public static final int					CPP_CODE		= 1;
	public static final int					JAVA_CODE		= 2;
	
	private static final LanguageCode[]		VALUES_ARRAY	= new LanguageCode[] { UNDEFINED_LITERAL, C_CODE_LITERAL,
			CPP_CODE_LITERAL, JAVA_CODE_LITERAL,			};
	
	public static final List<LanguageCode>	VALUES			= Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
	
	public static LanguageCode get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			LanguageCode result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}
	
	public static LanguageCode getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			LanguageCode result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}
	
	public static LanguageCode get(int value) {
		switch (value) {
			case UNDEFINED:
				return UNDEFINED_LITERAL;
			case C_CODE:
				return C_CODE_LITERAL;
			case CPP_CODE:
				return CPP_CODE_LITERAL;
			case JAVA_CODE:
				return JAVA_CODE_LITERAL;
			default:
				return UNDEFINED_LITERAL;
		}
	}
	
	private final int		value;
	
	private final String	name;
	
	private final String	literal;
	
	/**
	 * @param value
	 * @param name
	 * @param literal
	 */
	private LanguageCode(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.emf.common.util.Enumerator#getLiteral()
	 */
	public String getLiteral() {
		return literal;
	}
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.emf.common.util.Enumerator#getName()
	 */
	public String getName() {
		return name;
	}
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.emf.common.util.Enumerator#getValue()
	 */
	public int getValue() {
		return value;
	}
}
