/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.polychrony;

/**
 * This file contains all SignalTreeManager functions concerning the management of comments. Conversions of type between
 * C and Java
 */
public class SignalTreeComment {
	public SignalTreeComment() {};
	
	/**
	 * Add a commentTree to a node of the AST
	 * 
	 * @param node
	 *        the address of the node (ntree structure)
	 * @param commentTree
	 *        the address of the comment (ntree structure)
	 */
	public synchronized native void addComment(long node, long vattrtree);
	
	/**
	 * Add a comment to a node of the AST
	 * 
	 * @param node
	 *        the address of the node (ntree structure)
	 * @param comment
	 *        the string to add as comment
	 */
	public synchronized native void addStrComment(long node, String cstr, boolean bpre);
	
	/**
	 * Get the comment of a node <code>t</code> of the AST
	 * 
	 * @param node
	 *        the address of the node
	 * @return the adress of the comment (ntree structure) or PKTrees.ERROR_NODE if there is no comment
	 */
	public synchronized native long getComment(long node, boolean bpre);
	
	/**
	 * @param t
	 *        the tree
	 * @param l
	 *        the result tree
	 * @return a tree containing all the annotated nodes
	 */
	public synchronized native long getAnnotations(long t, long l);
	
	/**
	 * @param t
	 * @return true if a tree (t) is annotated with an error/warning, "false" otherwise. This annotation when it exists,
	 *         is a list of comments.
	 */
	public synchronized native long getAnnotation(long t);
	
}
