	/*******************************************************************************
	 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
	 * All rights reserved. This program and the accompanying materials
	 * are made available under the terms of the Eclipse Public License v1.0
	 * which accompanies this distribution, and is available at
	 * http://www.eclipse.org/legal/epl-v10.html
	 *
	 * Contributors:
	 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
	 */
	
	package org.eclipse.pop.ssme.polychrony.preferences;
	
	import org.eclipse.jface.preference.DirectoryFieldEditor;
	import org.eclipse.jface.preference.IPreferenceStore;
	import org.eclipse.jface.preference.IntegerFieldEditor;
	import org.eclipse.jface.preference.PathEditor;
	import org.eclipse.jface.preference.PreferencePage;
	import org.eclipse.pop.ssme.polychrony.EnvironmentConstants;
	import org.eclipse.pop.ssme.polychrony.PKServices;
	import org.eclipse.pop.ssme.polychrony.PkPlugin;
	import org.eclipse.swt.SWT;
	import org.eclipse.swt.layout.GridData;
	import org.eclipse.swt.layout.GridLayout;
	import org.eclipse.swt.widgets.Composite;
	import org.eclipse.swt.widgets.Control;
	import org.eclipse.swt.widgets.Label;
	import org.eclipse.ui.IWorkbench;
	import org.eclipse.ui.IWorkbenchPreferencePage;
	
	
	/**
	 * A preference page to configure all preferences of the SSME editor.
	 */
	public class SsmePreferencePage extends PreferencePage implements IWorkbenchPreferencePage {
		private IPreferenceStore	ps	= PkPlugin.getDefault().getPreferenceStore();
		
		/** Field to store paths to search POP libraries */
		private PathEditor			libraryPath;
		private DirectoryFieldEditor SignalPath;
		
		/** Field to specify the maximum number of entry in the table of types */
		private IntegerFieldEditor	typeTableSize;
		
		/** Field to specify the memory size to store POP.ree internal structure information */
		private IntegerFieldEditor	treeMemorySize;
		
		/** Field to specify the memory size to store POP.tring information */
		private IntegerFieldEditor	stringMemorySize;
		/**
		 * Creates this preference page contents.
		 * 
		 * @see org.eclipse.jface.preference.PreferencePage#createContents(org.eclipse.swt.widgets.Composite)
		 */
		protected Control createContents(Composite parent) {
			// Creates the container composite
			Composite container = new Composite(parent, SWT.NONE);
			GridLayout containerLayout = new GridLayout();
			containerLayout.marginWidth = 0;
			containerLayout.marginHeight = 0;
			container.setLayout(containerLayout);
			container.setLayoutData(new GridData(GridData.FILL_BOTH));
			
			createHeader(container);
			
			createFields(container);
			
			initDefaultValues();
			loadPreferences();
			
			return container;
		}
		
		/**
		 * Set the default value for each field of the POP.reference page
		 */
		private void initDefaultValues() {
			// String value =  PKServices.pK_SignalLib_Std; 
			// if (value != null) ps.setDefault(SsmePreferenceConstants.SIGNAL_LIBRARY_PATH, value);
			ps.setDefault(SsmePreferenceConstants.TYPE_TABLE_SIZE, EnvironmentConstants.TYPE_TABLE_SIZE_DEFAULT_VALUE);
			ps.setDefault(SsmePreferenceConstants.T_MEM_ARB, EnvironmentConstants.TREE_MEMORY_SIZE_DEFAULT_VALUE);
			ps.setDefault(SsmePreferenceConstants.CHAIN_MEM_ARB, EnvironmentConstants.STRING_MEMORY_SIZE_DEFAULT_VALUE);
		}
		
		/**
		 * Initializes the HMI with preference values.
		 */
		private void loadPreferences() {
			SignalPath.load();
			libraryPath.load();
			typeTableSize.load();
			treeMemorySize.load();
			stringMemorySize.load();
		}
		
		/**
		 * Stores the HMI values into the preference store.
		 */
		private void storePreferences() {
			SignalPath.store();
			libraryPath.store();
			typeTableSize.store();
			treeMemorySize.store();
			stringMemorySize.store();
		}
		
		/**
		 * Initializes the fields with default preference values.
		 */
		private void loadDefaultPreferences() {
			SignalPath.loadDefault();
			libraryPath.loadDefault();
			typeTableSize.loadDefault();
			treeMemorySize.loadDefault();
			stringMemorySize.loadDefault();
		}
		
		/**
		 * Creates this preference page header.
		 * 
		 * @param parent
		 *        the parent composite
		 */
		private void createHeader(Composite parent) {
			new Label(parent, SWT.WRAP).setText("General settings for the SignalToolBox for POP");
		}
		
		/**
		 * @param parent
		 *        the parent composite
		 */
		private void createFields(Composite parent) {
			Composite fieldsContainer = new Composite(parent, SWT.NONE);
			fieldsContainer.setLayout(new GridLayout());
			fieldsContainer.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));		
	
			Composite fieldsContainer1 = new Composite(fieldsContainer, SWT.NONE);	
			fieldsContainer1.setLayout(new GridLayout());
			fieldsContainer1.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
			
			SignalPath=  new DirectoryFieldEditor(SsmePreferenceConstants.SIGNALTOOLBOX_ROOT, "&SignalToolBox root (only updated after reboot):", fieldsContainer1);
			SignalPath.setPreferenceStore(ps);
			
			libraryPath = new PathEditor(SsmePreferenceConstants.SIGNAL_LIBRARY_PATH, "&Search paths for the SignalToolBox libraries",
				"&Select directories of POP libraries", fieldsContainer);
			libraryPath.setPreferenceStore(ps);
			
			typeTableSize = new IntegerFieldEditor(SsmePreferenceConstants.TYPE_TABLE_SIZE,
				"&Maximum number of entry in the type table (only updated after reboot)", fieldsContainer);
			typeTableSize.setPreferenceStore(ps);
			
			treeMemorySize = new IntegerFieldEditor(SsmePreferenceConstants.T_MEM_ARB,
				"&Memory size (in bytes) for the internal tree structure (only updated after reboot)", fieldsContainer);
			treeMemorySize.setPreferenceStore(ps);
			
			stringMemorySize = new IntegerFieldEditor(SsmePreferenceConstants.CHAIN_MEM_ARB,
				"&Memory size (in bytes) for the string structure (only updated after reboot)", fieldsContainer);
			stringMemorySize.setPreferenceStore(ps);
		}
		
		/**
		 * @see org.eclipse.ui.IWorkbenchPreferencePage#init(org.eclipse.ui.IWorkbench)
		 */
		public void init(IWorkbench workbench) {
		// Does nothing
		}
		
		/**
		 * @see org.eclipse.jface.preference.IPreferencePage#performOk()
		 */
		public boolean performOk() {
			storePreferences();
			// The Library Path is updated. Others preferences variables will only be updated after a reboot
			String value = ps.getString(SsmePreferenceConstants.SIGNAL_LIBRARY_PATH);
			PKServices.setSignalLibraryPath(value);
			return super.performOk();
		}
		

		/**
		 * @see org.eclipse.jface.preference.PreferencePage#performDefaults()
		 */
		protected void performDefaults() {
			loadDefaultPreferences();
			super.performDefaults();
		}
	}
