/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.polychrony.utils;

import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;

/**
 * Class used to accumulate the diagnostic during a call of the native part. To use it, clear it before each time you
 * apply the native part functionality to a new SME file.
 */
public class PolychronyDiagnostic {
	/** Used as accumulator of Diagnostic */
	private static BasicDiagnostic	currentDiagnostic;
	
	public static synchronized void add(int severity, String message, EObject obj) {
		getCurrentDiagnostic().merge(
			new BasicDiagnostic(severity, PolychronyMarkerHelper.ID_MARKER, 0, message, new Object[] { obj }));
	}
	
	public static synchronized void clear() {
		currentDiagnostic = null;
	}
	
	/**
	 * @return
	 */
	public static synchronized BasicDiagnostic getCurrentDiagnostic() {
		if (currentDiagnostic == null)
			currentDiagnostic = new BasicDiagnostic();
		return currentDiagnostic;
	}
	
	/**
	 * Iterates on all the Diagnostics contained by the BasicDiagnostic and removes those which appears more than once.
	 * 
	 * @return a Diagnostic with only unique Diagnostics
	 */
	public static synchronized Diagnostic getUniqueDiagnostics() {
		BasicDiagnostic result = new BasicDiagnostic();
		
		// Iterates on all the diagnostics found
		for (Diagnostic currentDiag : getCurrentDiagnostic().getChildren()) {
			boolean alreadyExist = false;
			
			// checks if the Diagnostic has not been already added
			for (Diagnostic uniqueDiag : result.getChildren()) {
				// checks the equality of the two Diagnostics
				if (currentDiag.getSeverity() == uniqueDiag.getSeverity()
						&& currentDiag.getCode() == uniqueDiag.getCode()
						&& currentDiag.getSource().equals(uniqueDiag.getSource())
						&& currentDiag.getMessage().equals(uniqueDiag.getMessage())
						&& currentDiag.getData().containsAll(uniqueDiag.getData())) {
					alreadyExist = true;
					break;
				}
			}
			if (!alreadyExist)
				result.add(currentDiag);
		}
		return result;
	}
}
