/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.polychrony.utils;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ResourceHelper {
	/**
	 * The eclipse workspace's root
	 */
	static final public IWorkspaceRoot	root	= ResourcesPlugin.getWorkspace().getRoot();
	
	/**
	 * This method is the one of the EcoreUtil class, but the returned URI is modify if the resource containing the
	 * EObject is present in the workspace
	 * 
	 * @param eObject
	 * @return
	 */
	public static URI getURI(EObject eObject) {
		// If it's a proxy, use that.
		URI proxyURI = ((InternalEObject) eObject).eProxyURI();
		if (proxyURI != null) {
			return proxyURI;
		}
		else {
			// If it is in a resource, form the URI relative to that resource.
			Resource resource = eObject.eResource();
			if (resource != null) {
				URI uri = resource.getURI();
				String path = uri.toString();
				
				if (path.startsWith(root.getLocationURI().toString())) {
					path = path.substring(root.getLocationURI().toString().length());
					uri = URI.createPlatformResourceURI(path, false);
				}
				return uri.appendFragment(resource.getURIFragment(eObject));
			}
			else {
				String id = EcoreUtil.getID(eObject);
				if (id != null) {
					return URI.createURI("#" + id);
				}
				else {
					InternalEObject internalEObject = (InternalEObject) eObject;
					List<String> uriFragmentPath = new ArrayList<String>();
					for (InternalEObject container = internalEObject.eInternalContainer(); container != null; container = internalEObject
							.eInternalContainer()) {
						uriFragmentPath.add(container.eURIFragmentSegment(internalEObject.eContainingFeature(),
							internalEObject));
						internalEObject = container;
					}
					
					StringBuffer result = new StringBuffer("#//");
					
					for (int i = uriFragmentPath.size() - 1; i >= 0; --i) {
						result.append('/');
						result.append(uriFragmentPath.get(i));
					}
					return URI.createURI(result.toString());
				}
			}
		}
	}
}
