/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>External Graph</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.ExternalGraph#getProcessAttributes <em>Process Attributes</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.ExternalGraph#getGraphSpecification <em>Graph Specification</em>}</li>
 * </ul>
 *
 * @see org.eclipse.pop.ssme.SsmePackage#getExternalGraph()
 * @model
 * @generated
 */
public interface ExternalGraph extends SignalElement {
	/**
	 * Returns the value of the '<em><b>Process Attributes</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.pop.ssme.ProcessAttribute}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Process Attributes</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Process Attributes</em>' containment reference list.
	 * @see org.eclipse.pop.ssme.SsmePackage#getExternalGraph_ProcessAttributes()
	 * @model containment="true"
	 * @generated
	 */
	EList<ProcessAttribute> getProcessAttributes();

	/**
	 * Returns the value of the '<em><b>Graph Specification</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Graph Specification</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Graph Specification</em>' containment reference.
	 * @see #setGraphSpecification(GraphSpecification)
	 * @see org.eclipse.pop.ssme.SsmePackage#getExternalGraph_GraphSpecification()
	 * @model containment="true"
	 * @generated
	 */
	GraphSpecification getGraphSpecification();

	/**
	 * Sets the value of the '{@link org.eclipse.pop.ssme.ExternalGraph#getGraphSpecification <em>Graph Specification</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Graph Specification</em>' containment reference.
	 * @see #getGraphSpecification()
	 * @generated
	 */
	void setGraphSpecification(GraphSpecification value);

} // ExternalGraph
