/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>IO Profile</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.IOProfile#getInputs <em>Inputs</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.IOProfile#getOutputs <em>Outputs</em>}</li>
 * </ul>
 *
 * @see org.eclipse.pop.ssme.SsmePackage#getIOProfile()
 * @model
 * @generated
 */
public interface IOProfile extends SignalElement {
	/**
	 * Returns the value of the '<em><b>Inputs</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.pop.ssme.TypesOrSignalsDeclaration}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Inputs</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Inputs</em>' containment reference list.
	 * @see org.eclipse.pop.ssme.SsmePackage#getIOProfile_Inputs()
	 * @model containment="true"
	 * @generated
	 */
	EList<TypesOrSignalsDeclaration> getInputs();

	/**
	 * Returns the value of the '<em><b>Outputs</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.pop.ssme.TypesOrSignalsDeclaration}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Outputs</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Outputs</em>' containment reference list.
	 * @see org.eclipse.pop.ssme.SsmePackage#getIOProfile_Outputs()
	 * @model containment="true"
	 * @generated
	 */
	EList<TypesOrSignalsDeclaration> getOutputs();

} // IOProfile
