/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Intervals Kind</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see org.eclipse.pop.ssme.SsmePackage#getIntervalsKind()
 * @model
 * @generated
 */
public enum IntervalsKind implements Enumerator {
	/**
	 * The '<em><b>Left Closed Right Closed</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #LEFT_CLOSED_RIGHT_CLOSED
	 * @generated
	 * @ordered
	 */
	LEFT_CLOSED_RIGHT_CLOSED_LITERAL(0, "LeftClosedRightClosed", "LeftClosedRightClosed"),

	/**
	 * The '<em><b>Left Closed Right Opened</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #LEFT_CLOSED_RIGHT_OPENED
	 * @generated
	 * @ordered
	 */
	LEFT_CLOSED_RIGHT_OPENED_LITERAL(1, "LeftClosedRightOpened", "LeftClosedRightOpened"),

	/**
	 * The '<em><b>Left Opened Right Closed</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #LEFT_OPENED_RIGHT_CLOSED
	 * @generated
	 * @ordered
	 */
	LEFT_OPENED_RIGHT_CLOSED_LITERAL(2, "LeftOpenedRightClosed", "LeftOpenedRightClosed"),

	/**
	 * The '<em><b>Left Opened Right Opened</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #LEFT_OPENED_RIGHT_OPENED
	 * @generated
	 * @ordered
	 */
	LEFT_OPENED_RIGHT_OPENED_LITERAL(3, "LeftOpenedRightOpened", "LeftOpenedRightOpened");

	/**
	 * The '<em><b>Left Closed Right Closed</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Left Closed Right Closed</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #LEFT_CLOSED_RIGHT_CLOSED_LITERAL
	 * @model name="LeftClosedRightClosed"
	 * @generated
	 * @ordered
	 */
	public static final int LEFT_CLOSED_RIGHT_CLOSED = 0;

	/**
	 * The '<em><b>Left Closed Right Opened</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Left Closed Right Opened</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #LEFT_CLOSED_RIGHT_OPENED_LITERAL
	 * @model name="LeftClosedRightOpened"
	 * @generated
	 * @ordered
	 */
	public static final int LEFT_CLOSED_RIGHT_OPENED = 1;

	/**
	 * The '<em><b>Left Opened Right Closed</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Left Opened Right Closed</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #LEFT_OPENED_RIGHT_CLOSED_LITERAL
	 * @model name="LeftOpenedRightClosed"
	 * @generated
	 * @ordered
	 */
	public static final int LEFT_OPENED_RIGHT_CLOSED = 2;

	/**
	 * The '<em><b>Left Opened Right Opened</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Left Opened Right Opened</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #LEFT_OPENED_RIGHT_OPENED_LITERAL
	 * @model name="LeftOpenedRightOpened"
	 * @generated
	 * @ordered
	 */
	public static final int LEFT_OPENED_RIGHT_OPENED = 3;

	/**
	 * An array of all the '<em><b>Intervals Kind</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final IntervalsKind[] VALUES_ARRAY =
		new IntervalsKind[] {
			LEFT_CLOSED_RIGHT_CLOSED_LITERAL,
			LEFT_CLOSED_RIGHT_OPENED_LITERAL,
			LEFT_OPENED_RIGHT_CLOSED_LITERAL,
			LEFT_OPENED_RIGHT_OPENED_LITERAL,
		};

	/**
	 * A public read-only list of all the '<em><b>Intervals Kind</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<IntervalsKind> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Intervals Kind</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param literal the literal.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static IntervalsKind get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			IntervalsKind result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Intervals Kind</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param name the name.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static IntervalsKind getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			IntervalsKind result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Intervals Kind</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the integer value.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static IntervalsKind get(int value) {
		switch (value) {
			case LEFT_CLOSED_RIGHT_CLOSED: return LEFT_CLOSED_RIGHT_CLOSED_LITERAL;
			case LEFT_CLOSED_RIGHT_OPENED: return LEFT_CLOSED_RIGHT_OPENED_LITERAL;
			case LEFT_OPENED_RIGHT_CLOSED: return LEFT_OPENED_RIGHT_CLOSED_LITERAL;
			case LEFT_OPENED_RIGHT_OPENED: return LEFT_OPENED_RIGHT_OPENED_LITERAL;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private IntervalsKind(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //IntervalsKind
