/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Iteration</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.Iteration#getPartialIteration <em>Partial Iteration</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.Iteration#getElemDefinition <em>Elem Definition</em>}</li>
 * </ul>
 *
 * @see org.eclipse.pop.ssme.SsmePackage#getIteration()
 * @model
 * @generated
 */
public interface Iteration extends PartialArrayDefinition {
	/**
	 * Returns the value of the '<em><b>Partial Iteration</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.pop.ssme.PartialIteration}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Partial Iteration</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Partial Iteration</em>' containment reference list.
	 * @see org.eclipse.pop.ssme.SsmePackage#getIteration_PartialIteration()
	 * @model containment="true" required="true"
	 * @generated
	 */
	EList<PartialIteration> getPartialIteration();

	/**
	 * Returns the value of the '<em><b>Elem Definition</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Elem Definition</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Elem Definition</em>' containment reference.
	 * @see #setElemDefinition(ExprSignal)
	 * @see org.eclipse.pop.ssme.SsmePackage#getIteration_ElemDefinition()
	 * @model containment="true" required="true"
	 * @generated
	 */
	ExprSignal getElemDefinition();

	/**
	 * Sets the value of the '{@link org.eclipse.pop.ssme.Iteration#getElemDefinition <em>Elem Definition</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Elem Definition</em>' containment reference.
	 * @see #getElemDefinition()
	 * @generated
	 */
	void setElemDefinition(ExprSignal value);

} // Iteration
