/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Masking</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.Masking#getExprProcess <em>Expr Process</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.Masking#getListIdentifier <em>List Identifier</em>}</li>
 * </ul>
 *
 * @see org.eclipse.pop.ssme.SsmePackage#getMasking()
 * @model
 * @generated
 */
public interface Masking extends ExprProcess {
	/**
	 * Returns the value of the '<em><b>Expr Process</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Expr Process</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Expr Process</em>' containment reference.
	 * @see #setExprProcess(ExprProcess)
	 * @see org.eclipse.pop.ssme.SsmePackage#getMasking_ExprProcess()
	 * @model containment="true" required="true"
	 * @generated
	 */
	ExprProcess getExprProcess();

	/**
	 * Sets the value of the '{@link org.eclipse.pop.ssme.Masking#getExprProcess <em>Expr Process</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Expr Process</em>' containment reference.
	 * @see #getExprProcess()
	 * @generated
	 */
	void setExprProcess(ExprProcess value);

	/**
	 * Returns the value of the '<em><b>List Identifier</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.pop.ssme.Identifier}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>List Identifier</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>List Identifier</em>' containment reference list.
	 * @see org.eclipse.pop.ssme.SsmePackage#getMasking_ListIdentifier()
	 * @model containment="true" required="true"
	 * @generated
	 */
	EList<Identifier> getListIdentifier();

} // Masking
