/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Process Type</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.ProcessType#getModelKind <em>Model Kind</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.ProcessType#getIdentifier <em>Identifier</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.ProcessType#getInterfaceDefinition <em>Interface Definition</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.ProcessType#getListPragma <em>List Pragma</em>}</li>
 * </ul>
 *
 * @see org.eclipse.pop.ssme.SsmePackage#getProcessType()
 * @model
 * @generated
 */
public interface ProcessType extends TypeDefinition {
	/**
	 * Returns the value of the '<em><b>Model Kind</b></em>' attribute.
	 * The literals are from the enumeration {@link org.eclipse.pop.ssme.ModelKind}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Model Kind</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Model Kind</em>' attribute.
	 * @see org.eclipse.pop.ssme.ModelKind
	 * @see #setModelKind(ModelKind)
	 * @see org.eclipse.pop.ssme.SsmePackage#getProcessType_ModelKind()
	 * @model required="true"
	 * @generated
	 */
	ModelKind getModelKind();

	/**
	 * Sets the value of the '{@link org.eclipse.pop.ssme.ProcessType#getModelKind <em>Model Kind</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Model Kind</em>' attribute.
	 * @see org.eclipse.pop.ssme.ModelKind
	 * @see #getModelKind()
	 * @generated
	 */
	void setModelKind(ModelKind value);

	/**
	 * Returns the value of the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Identifier</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Identifier</em>' containment reference.
	 * @see #setIdentifier(Identifier)
	 * @see org.eclipse.pop.ssme.SsmePackage#getProcessType_Identifier()
	 * @model containment="true" required="true"
	 * @generated
	 */
	Identifier getIdentifier();

	/**
	 * Sets the value of the '{@link org.eclipse.pop.ssme.ProcessType#getIdentifier <em>Identifier</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Identifier</em>' containment reference.
	 * @see #getIdentifier()
	 * @generated
	 */
	void setIdentifier(Identifier value);

	/**
	 * Returns the value of the '<em><b>Interface Definition</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Interface Definition</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Interface Definition</em>' containment reference.
	 * @see #setInterfaceDefinition(InterfaceDefinition)
	 * @see org.eclipse.pop.ssme.SsmePackage#getProcessType_InterfaceDefinition()
	 * @model containment="true" required="true"
	 * @generated
	 */
	InterfaceDefinition getInterfaceDefinition();

	/**
	 * Sets the value of the '{@link org.eclipse.pop.ssme.ProcessType#getInterfaceDefinition <em>Interface Definition</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Interface Definition</em>' containment reference.
	 * @see #getInterfaceDefinition()
	 * @generated
	 */
	void setInterfaceDefinition(InterfaceDefinition value);

	/**
	 * Returns the value of the '<em><b>List Pragma</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.pop.ssme.Pragma}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>List Pragma</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>List Pragma</em>' containment reference list.
	 * @see org.eclipse.pop.ssme.SsmePackage#getProcessType_ListPragma()
	 * @model containment="true"
	 * @generated
	 */
	EList<Pragma> getListPragma();

} // ProcessType
