/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Signal Element</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.SignalElement#getCommentPre <em>Comment Pre</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.SignalElement#getCommentPost <em>Comment Post</em>}</li>
 * </ul>
 *
 * @see org.eclipse.pop.ssme.SsmePackage#getSignalElement()
 * @model
 * @generated
 */
public interface SignalElement extends EObject {
	/**
	 * Returns the value of the '<em><b>Comment Pre</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.pop.ssme.Comment}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Comment Pre</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Comment Pre</em>' containment reference list.
	 * @see org.eclipse.pop.ssme.SsmePackage#getSignalElement_CommentPre()
	 * @model containment="true"
	 * @generated
	 */
	EList<Comment> getCommentPre();

	/**
	 * Returns the value of the '<em><b>Comment Post</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.pop.ssme.Comment}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Comment Post</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Comment Post</em>' containment reference list.
	 * @see org.eclipse.pop.ssme.SsmePackage#getSignalElement_CommentPost()
	 * @model containment="true"
	 * @generated
	 */
	EList<Comment> getCommentPost();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model kind="operation"
	 * @generated
	 */
	void getParent();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model required="true"
	 * @generated
	 */
	long makeAST();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model sigElemRequired="true" treeRequired="true"
	 * @generated
	 */
	void setASTAttribute(EObject sigElem, long tree);

} // SignalElement
