/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme;


/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Type Morphism</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.TypeMorphism#getDescribedType <em>Described Type</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.TypeMorphism#getTypeDescriptionValue <em>Type Description Value</em>}</li>
 * </ul>
 *
 * @see org.eclipse.pop.ssme.SsmePackage#getTypeMorphism()
 * @model
 * @generated
 */
public interface TypeMorphism extends TypeDefinition {
	/**
	 * Returns the value of the '<em><b>Described Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Described Type</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Described Type</em>' containment reference.
	 * @see #setDescribedType(DescribedType)
	 * @see org.eclipse.pop.ssme.SsmePackage#getTypeMorphism_DescribedType()
	 * @model containment="true" required="true"
	 * @generated
	 */
	DescribedType getDescribedType();

	/**
	 * Sets the value of the '{@link org.eclipse.pop.ssme.TypeMorphism#getDescribedType <em>Described Type</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Described Type</em>' containment reference.
	 * @see #getDescribedType()
	 * @generated
	 */
	void setDescribedType(DescribedType value);

	/**
	 * Returns the value of the '<em><b>Type Description Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Type Description Value</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Type Description Value</em>' containment reference.
	 * @see #setTypeDescriptionValue(TypeDescriptionValue)
	 * @see org.eclipse.pop.ssme.SsmePackage#getTypeMorphism_TypeDescriptionValue()
	 * @model containment="true" required="true"
	 * @generated
	 */
	TypeDescriptionValue getTypeDescriptionValue();

	/**
	 * Sets the value of the '{@link org.eclipse.pop.ssme.TypeMorphism#getTypeDescriptionValue <em>Type Description Value</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Type Description Value</em>' containment reference.
	 * @see #getTypeDescriptionValue()
	 * @generated
	 */
	void setTypeDescriptionValue(TypeDescriptionValue value);

} // TypeMorphism
