/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Unconditioned Dependences</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.UnconditionedDependences#getSignals <em>Signals</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.UnconditionedDependences#getDependenceElementsList <em>Dependence Elements List</em>}</li>
 * </ul>
 *
 * @see org.eclipse.pop.ssme.SsmePackage#getUnconditionedDependences()
 * @model
 * @generated
 */
public interface UnconditionedDependences extends Dependences {
	/**
	 * Returns the value of the '<em><b>Signals</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Signals</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Signals</em>' containment reference.
	 * @see #setSignals(Signals)
	 * @see org.eclipse.pop.ssme.SsmePackage#getUnconditionedDependences_Signals()
	 * @model containment="true" required="true"
	 * @generated
	 */
	Signals getSignals();

	/**
	 * Sets the value of the '{@link org.eclipse.pop.ssme.UnconditionedDependences#getSignals <em>Signals</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Signals</em>' containment reference.
	 * @see #getSignals()
	 * @generated
	 */
	void setSignals(Signals value);

	/**
	 * Returns the value of the '<em><b>Dependence Elements List</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.pop.ssme.Signals}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Dependence Elements List</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Dependence Elements List</em>' containment reference list.
	 * @see org.eclipse.pop.ssme.SsmePackage#getUnconditionedDependences_DependenceElementsList()
	 * @model containment="true" required="true"
	 * @generated
	 */
	EList<Signals> getDependenceElementsList();

} // UnconditionedDependences
