/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.pop.ssme.ArrayElementsEnumeration;
import org.eclipse.pop.ssme.PartialArrayDefinition;
import org.eclipse.pop.ssme.SsmePackage;
import org.eclipse.pop.ssme.polychrony.PKTrees;
import org.eclipse.pop.ssme.polychrony.PkPlugin;
import org.eclipse.pop.ssme.polychrony.SignalOperators;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Array Elements Enumeration</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.impl.ArrayElementsEnumerationImpl#getListPartialArrayDefinition <em>List Partial Array Definition</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ArrayElementsEnumerationImpl extends SignalElementImpl implements ArrayElementsEnumeration {
	/**
	 * The cached value of the '{@link #getListPartialArrayDefinition() <em>List Partial Array Definition</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getListPartialArrayDefinition()
	 * @generated
	 * @ordered
	 */
	protected EList<PartialArrayDefinition> listPartialArrayDefinition;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ArrayElementsEnumerationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SsmePackage.eINSTANCE.getArrayElementsEnumeration();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<PartialArrayDefinition> getListPartialArrayDefinition() {
		if (listPartialArrayDefinition == null) {
			listPartialArrayDefinition = new EObjectContainmentEList<PartialArrayDefinition>(PartialArrayDefinition.class, this, SsmePackage.ARRAY_ELEMENTS_ENUMERATION__LIST_PARTIAL_ARRAY_DEFINITION);
		}
		return listPartialArrayDefinition;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case SsmePackage.ARRAY_ELEMENTS_ENUMERATION__LIST_PARTIAL_ARRAY_DEFINITION:
				return ((InternalEList<?>)getListPartialArrayDefinition()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SsmePackage.ARRAY_ELEMENTS_ENUMERATION__LIST_PARTIAL_ARRAY_DEFINITION:
				return getListPartialArrayDefinition();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SsmePackage.ARRAY_ELEMENTS_ENUMERATION__LIST_PARTIAL_ARRAY_DEFINITION:
				getListPartialArrayDefinition().clear();
				getListPartialArrayDefinition().addAll((Collection<? extends PartialArrayDefinition>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SsmePackage.ARRAY_ELEMENTS_ENUMERATION__LIST_PARTIAL_ARRAY_DEFINITION:
				getListPartialArrayDefinition().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SsmePackage.ARRAY_ELEMENTS_ENUMERATION__LIST_PARTIAL_ARRAY_DEFINITION:
				return listPartialArrayDefinition != null && !listPartialArrayDefinition.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public long makeAST() {
		PKTrees API = PkPlugin.getTreeAPI();
		long result = PKTrees.ERROR_NODE;
		
		long listEnumVectNode = API.getNilTree();
		if (getListPartialArrayDefinition() != null && !getListPartialArrayDefinition().isEmpty()) {
			listEnumVectNode = API.makeEmptyList(SignalOperators.oplelevec);
			for (PartialArrayDefinition elemVecteur : getListPartialArrayDefinition()) {
				long elemVecteurNode = elemVecteur.makeAST();
				if (elemVecteurNode != PKTrees.ERROR_NODE) {
					listEnumVectNode = API.post(listEnumVectNode, elemVecteurNode);
				}
			}
		}
		else {
			listEnumVectNode = API.makeNullary(SignalOperators.optabvide);
		}
		
		if (listEnumVectNode != PKTrees.ERROR_NODE) {
			result = listEnumVectNode;
		}
		setASTAttribute(this, result);
		return result;
	}

} //ArrayElementsEnumerationImpl
