/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.pop.ssme.ArrayIndex;
import org.eclipse.pop.ssme.ArrayProcess;
import org.eclipse.pop.ssme.ExprProcess;
import org.eclipse.pop.ssme.SsmePackage;
import org.eclipse.pop.ssme.polychrony.PKTrees;
import org.eclipse.pop.ssme.polychrony.PkPlugin;
import org.eclipse.pop.ssme.polychrony.SignalOperators;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Array Process</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.impl.ArrayProcessImpl#getArrayIndex <em>Array Index</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.impl.ArrayProcessImpl#getExprProcess <em>Expr Process</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.impl.ArrayProcessImpl#getIterationInit <em>Iteration Init</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ArrayProcessImpl extends SignalElementImpl implements ArrayProcess {
	/**
	 * The cached value of the '{@link #getArrayIndex() <em>Array Index</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getArrayIndex()
	 * @generated
	 * @ordered
	 */
	protected ArrayIndex arrayIndex;

	/**
	 * The cached value of the '{@link #getExprProcess() <em>Expr Process</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getExprProcess()
	 * @generated
	 * @ordered
	 */
	protected ExprProcess exprProcess;

	/**
	 * The cached value of the '{@link #getIterationInit() <em>Iteration Init</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIterationInit()
	 * @generated
	 * @ordered
	 */
	protected ExprProcess iterationInit;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ArrayProcessImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SsmePackage.eINSTANCE.getArrayProcess();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ArrayIndex getArrayIndex() {
		return arrayIndex;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetArrayIndex(ArrayIndex newArrayIndex, NotificationChain msgs) {
		ArrayIndex oldArrayIndex = arrayIndex;
		arrayIndex = newArrayIndex;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.ARRAY_PROCESS__ARRAY_INDEX, oldArrayIndex, newArrayIndex);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setArrayIndex(ArrayIndex newArrayIndex) {
		if (newArrayIndex != arrayIndex) {
			NotificationChain msgs = null;
			if (arrayIndex != null)
				msgs = ((InternalEObject)arrayIndex).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.ARRAY_PROCESS__ARRAY_INDEX, null, msgs);
			if (newArrayIndex != null)
				msgs = ((InternalEObject)newArrayIndex).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.ARRAY_PROCESS__ARRAY_INDEX, null, msgs);
			msgs = basicSetArrayIndex(newArrayIndex, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.ARRAY_PROCESS__ARRAY_INDEX, newArrayIndex, newArrayIndex));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ExprProcess getExprProcess() {
		return exprProcess;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetExprProcess(ExprProcess newExprProcess, NotificationChain msgs) {
		ExprProcess oldExprProcess = exprProcess;
		exprProcess = newExprProcess;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.ARRAY_PROCESS__EXPR_PROCESS, oldExprProcess, newExprProcess);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setExprProcess(ExprProcess newExprProcess) {
		if (newExprProcess != exprProcess) {
			NotificationChain msgs = null;
			if (exprProcess != null)
				msgs = ((InternalEObject)exprProcess).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.ARRAY_PROCESS__EXPR_PROCESS, null, msgs);
			if (newExprProcess != null)
				msgs = ((InternalEObject)newExprProcess).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.ARRAY_PROCESS__EXPR_PROCESS, null, msgs);
			msgs = basicSetExprProcess(newExprProcess, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.ARRAY_PROCESS__EXPR_PROCESS, newExprProcess, newExprProcess));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ExprProcess getIterationInit() {
		return iterationInit;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetIterationInit(ExprProcess newIterationInit, NotificationChain msgs) {
		ExprProcess oldIterationInit = iterationInit;
		iterationInit = newIterationInit;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.ARRAY_PROCESS__ITERATION_INIT, oldIterationInit, newIterationInit);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIterationInit(ExprProcess newIterationInit) {
		if (newIterationInit != iterationInit) {
			NotificationChain msgs = null;
			if (iterationInit != null)
				msgs = ((InternalEObject)iterationInit).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.ARRAY_PROCESS__ITERATION_INIT, null, msgs);
			if (newIterationInit != null)
				msgs = ((InternalEObject)newIterationInit).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.ARRAY_PROCESS__ITERATION_INIT, null, msgs);
			msgs = basicSetIterationInit(newIterationInit, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.ARRAY_PROCESS__ITERATION_INIT, newIterationInit, newIterationInit));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case SsmePackage.ARRAY_PROCESS__ARRAY_INDEX:
				return basicSetArrayIndex(null, msgs);
			case SsmePackage.ARRAY_PROCESS__EXPR_PROCESS:
				return basicSetExprProcess(null, msgs);
			case SsmePackage.ARRAY_PROCESS__ITERATION_INIT:
				return basicSetIterationInit(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SsmePackage.ARRAY_PROCESS__ARRAY_INDEX:
				return getArrayIndex();
			case SsmePackage.ARRAY_PROCESS__EXPR_PROCESS:
				return getExprProcess();
			case SsmePackage.ARRAY_PROCESS__ITERATION_INIT:
				return getIterationInit();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SsmePackage.ARRAY_PROCESS__ARRAY_INDEX:
				setArrayIndex((ArrayIndex)newValue);
				return;
			case SsmePackage.ARRAY_PROCESS__EXPR_PROCESS:
				setExprProcess((ExprProcess)newValue);
				return;
			case SsmePackage.ARRAY_PROCESS__ITERATION_INIT:
				setIterationInit((ExprProcess)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SsmePackage.ARRAY_PROCESS__ARRAY_INDEX:
				setArrayIndex((ArrayIndex)null);
				return;
			case SsmePackage.ARRAY_PROCESS__EXPR_PROCESS:
				setExprProcess((ExprProcess)null);
				return;
			case SsmePackage.ARRAY_PROCESS__ITERATION_INIT:
				setIterationInit((ExprProcess)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SsmePackage.ARRAY_PROCESS__ARRAY_INDEX:
				return arrayIndex != null;
			case SsmePackage.ARRAY_PROCESS__EXPR_PROCESS:
				return exprProcess != null;
			case SsmePackage.ARRAY_PROCESS__ITERATION_INIT:
				return iterationInit != null;
		}
		return super.eIsSet(featureID);
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public long makeAST() {
		long result = PKTrees.ERROR_NODE;
		PKTrees API = PkPlugin.getTreeAPI();
		
		long nodeIndiceMotif = API.getNilTree();
		if (getArrayIndex() != null) {
			nodeIndiceMotif = getArrayIndex().makeAST();
		}
		
		long eProcNode = API.getNilTree();
		if (getExprProcess() != null) {
			eProcNode = getExprProcess().makeAST();
		}
		
		long initMotif = API.getNilTree();
		if (getIterationInit() != null) {
			initMotif = getIterationInit().makeAST();
		}
		
		if (nodeIndiceMotif != PKTrees.ERROR_NODE && eProcNode != PKTrees.ERROR_NODE) {
			result = API.makeTernary(SignalOperators.opmoti, nodeIndiceMotif, eProcNode, initMotif);
		}
		setASTAttribute(this, result);
		return result;
	}
} //ArrayProcessImpl
