/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.pop.ssme.ArrayType;
import org.eclipse.pop.ssme.ListExprSignal;
import org.eclipse.pop.ssme.SsmePackage;
import org.eclipse.pop.ssme.Type;
import org.eclipse.pop.ssme.polychrony.PKTrees;
import org.eclipse.pop.ssme.polychrony.PkPlugin;
import org.eclipse.pop.ssme.polychrony.SignalOperators;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Array Type</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.impl.ArrayTypeImpl#getExprDimension <em>Expr Dimension</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.impl.ArrayTypeImpl#getType <em>Type</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ArrayTypeImpl extends SignalElementImpl implements ArrayType {
	/**
	 * The cached value of the '{@link #getExprDimension() <em>Expr Dimension</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getExprDimension()
	 * @generated
	 * @ordered
	 */
	protected ListExprSignal exprDimension;

	/**
	 * The cached value of the '{@link #getType() <em>Type</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected Type type;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ArrayTypeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SsmePackage.eINSTANCE.getArrayType();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ListExprSignal getExprDimension() {
		return exprDimension;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetExprDimension(ListExprSignal newExprDimension, NotificationChain msgs) {
		ListExprSignal oldExprDimension = exprDimension;
		exprDimension = newExprDimension;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.ARRAY_TYPE__EXPR_DIMENSION, oldExprDimension, newExprDimension);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setExprDimension(ListExprSignal newExprDimension) {
		if (newExprDimension != exprDimension) {
			NotificationChain msgs = null;
			if (exprDimension != null)
				msgs = ((InternalEObject)exprDimension).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.ARRAY_TYPE__EXPR_DIMENSION, null, msgs);
			if (newExprDimension != null)
				msgs = ((InternalEObject)newExprDimension).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.ARRAY_TYPE__EXPR_DIMENSION, null, msgs);
			msgs = basicSetExprDimension(newExprDimension, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.ARRAY_TYPE__EXPR_DIMENSION, newExprDimension, newExprDimension));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Type getType() {
		return type;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetType(Type newType, NotificationChain msgs) {
		Type oldType = type;
		type = newType;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.ARRAY_TYPE__TYPE, oldType, newType);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setType(Type newType) {
		if (newType != type) {
			NotificationChain msgs = null;
			if (type != null)
				msgs = ((InternalEObject)type).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.ARRAY_TYPE__TYPE, null, msgs);
			if (newType != null)
				msgs = ((InternalEObject)newType).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.ARRAY_TYPE__TYPE, null, msgs);
			msgs = basicSetType(newType, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.ARRAY_TYPE__TYPE, newType, newType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case SsmePackage.ARRAY_TYPE__EXPR_DIMENSION:
				return basicSetExprDimension(null, msgs);
			case SsmePackage.ARRAY_TYPE__TYPE:
				return basicSetType(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SsmePackage.ARRAY_TYPE__EXPR_DIMENSION:
				return getExprDimension();
			case SsmePackage.ARRAY_TYPE__TYPE:
				return getType();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SsmePackage.ARRAY_TYPE__EXPR_DIMENSION:
				setExprDimension((ListExprSignal)newValue);
				return;
			case SsmePackage.ARRAY_TYPE__TYPE:
				setType((Type)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SsmePackage.ARRAY_TYPE__EXPR_DIMENSION:
				setExprDimension((ListExprSignal)null);
				return;
			case SsmePackage.ARRAY_TYPE__TYPE:
				setType((Type)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SsmePackage.ARRAY_TYPE__EXPR_DIMENSION:
				return exprDimension != null;
			case SsmePackage.ARRAY_TYPE__TYPE:
				return type != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public long makeAST() {
		PKTrees API = PkPlugin.getTreeAPI();
		long result = PKTrees.ERROR_NODE;
		
		long listESig = API.getNilTree();
		if (getExprDimension() != null && !getExprDimension().getExprSignal().isEmpty()) {
			listESig = getExprDimension().makeAST();
		}
		
		long typeNode = API.getNilTree();
		if (getType() != null) {
			typeNode = getType().makeAST();
		}
		
		if (typeNode != PKTrees.ERROR_NODE) {
			result = API.makeBinary(SignalOperators.optvect, listESig, typeNode);
		}
		setASTAttribute(this, result);
		return result;
	}

} //ArrayTypeImpl
