/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.pop.ssme.CaseBranch;
import org.eclipse.pop.ssme.CaseProcess;
import org.eclipse.pop.ssme.ExprProcess;
import org.eclipse.pop.ssme.Identifier;
import org.eclipse.pop.ssme.SsmePackage;
import org.eclipse.pop.ssme.polychrony.PKTrees;
import org.eclipse.pop.ssme.polychrony.PkPlugin;
import org.eclipse.pop.ssme.polychrony.SignalOperators;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Case Process</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.impl.CaseProcessImpl#getIdentifier <em>Identifier</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.impl.CaseProcessImpl#getListCaseBranch <em>List Case Branch</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.impl.CaseProcessImpl#getElseCase <em>Else Case</em>}</li>
 * </ul>
 *
 * @generated
 */
public class CaseProcessImpl extends SignalElementImpl implements CaseProcess {
	/**
	 * The cached value of the '{@link #getIdentifier() <em>Identifier</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIdentifier()
	 * @generated
	 * @ordered
	 */
	protected Identifier identifier;

	/**
	 * The cached value of the '{@link #getListCaseBranch() <em>List Case Branch</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getListCaseBranch()
	 * @generated
	 * @ordered
	 */
	protected EList<CaseBranch> listCaseBranch;

	/**
	 * The cached value of the '{@link #getElseCase() <em>Else Case</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getElseCase()
	 * @generated
	 * @ordered
	 */
	protected ExprProcess elseCase;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CaseProcessImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SsmePackage.eINSTANCE.getCaseProcess();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Identifier getIdentifier() {
		return identifier;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetIdentifier(Identifier newIdentifier, NotificationChain msgs) {
		Identifier oldIdentifier = identifier;
		identifier = newIdentifier;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.CASE_PROCESS__IDENTIFIER, oldIdentifier, newIdentifier);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIdentifier(Identifier newIdentifier) {
		if (newIdentifier != identifier) {
			NotificationChain msgs = null;
			if (identifier != null)
				msgs = ((InternalEObject)identifier).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.CASE_PROCESS__IDENTIFIER, null, msgs);
			if (newIdentifier != null)
				msgs = ((InternalEObject)newIdentifier).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.CASE_PROCESS__IDENTIFIER, null, msgs);
			msgs = basicSetIdentifier(newIdentifier, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.CASE_PROCESS__IDENTIFIER, newIdentifier, newIdentifier));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<CaseBranch> getListCaseBranch() {
		if (listCaseBranch == null) {
			listCaseBranch = new EObjectContainmentEList<CaseBranch>(CaseBranch.class, this, SsmePackage.CASE_PROCESS__LIST_CASE_BRANCH);
		}
		return listCaseBranch;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ExprProcess getElseCase() {
		return elseCase;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetElseCase(ExprProcess newElseCase, NotificationChain msgs) {
		ExprProcess oldElseCase = elseCase;
		elseCase = newElseCase;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.CASE_PROCESS__ELSE_CASE, oldElseCase, newElseCase);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setElseCase(ExprProcess newElseCase) {
		if (newElseCase != elseCase) {
			NotificationChain msgs = null;
			if (elseCase != null)
				msgs = ((InternalEObject)elseCase).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.CASE_PROCESS__ELSE_CASE, null, msgs);
			if (newElseCase != null)
				msgs = ((InternalEObject)newElseCase).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.CASE_PROCESS__ELSE_CASE, null, msgs);
			msgs = basicSetElseCase(newElseCase, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.CASE_PROCESS__ELSE_CASE, newElseCase, newElseCase));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case SsmePackage.CASE_PROCESS__IDENTIFIER:
				return basicSetIdentifier(null, msgs);
			case SsmePackage.CASE_PROCESS__LIST_CASE_BRANCH:
				return ((InternalEList<?>)getListCaseBranch()).basicRemove(otherEnd, msgs);
			case SsmePackage.CASE_PROCESS__ELSE_CASE:
				return basicSetElseCase(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SsmePackage.CASE_PROCESS__IDENTIFIER:
				return getIdentifier();
			case SsmePackage.CASE_PROCESS__LIST_CASE_BRANCH:
				return getListCaseBranch();
			case SsmePackage.CASE_PROCESS__ELSE_CASE:
				return getElseCase();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SsmePackage.CASE_PROCESS__IDENTIFIER:
				setIdentifier((Identifier)newValue);
				return;
			case SsmePackage.CASE_PROCESS__LIST_CASE_BRANCH:
				getListCaseBranch().clear();
				getListCaseBranch().addAll((Collection<? extends CaseBranch>)newValue);
				return;
			case SsmePackage.CASE_PROCESS__ELSE_CASE:
				setElseCase((ExprProcess)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SsmePackage.CASE_PROCESS__IDENTIFIER:
				setIdentifier((Identifier)null);
				return;
			case SsmePackage.CASE_PROCESS__LIST_CASE_BRANCH:
				getListCaseBranch().clear();
				return;
			case SsmePackage.CASE_PROCESS__ELSE_CASE:
				setElseCase((ExprProcess)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SsmePackage.CASE_PROCESS__IDENTIFIER:
				return identifier != null;
			case SsmePackage.CASE_PROCESS__LIST_CASE_BRANCH:
				return listCaseBranch != null && !listCaseBranch.isEmpty();
			case SsmePackage.CASE_PROCESS__ELSE_CASE:
				return elseCase != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public long makeAST() {
		PKTrees API = PkPlugin.getTreeAPI();
		long result = PKTrees.ERROR_NODE;
		
		long idNode = API.getNilTree();
		if (getIdentifier() != null) {
			idNode = getIdentifier().makeAST();
		}
		
		long caseNode = API.getNilTree();
		
		if (getListCaseBranch() != null && !getListCaseBranch().isEmpty()) {
			caseNode = API.makeEmptyList(SignalOperators.oplcas);
			for (CaseBranch cases : getListCaseBranch()) {
				long node = cases.makeAST();
				if (node != PKTrees.ERROR_NODE) {
					caseNode = API.post(caseNode, node);
				}
			}
		}
		
		long elseNode = API.getNilTree();
		if (getElseCase() != null) {
			elseNode = getElseCase().makeAST();
		}
		
		if (idNode != PKTrees.ERROR_NODE && caseNode != PKTrees.ERROR_NODE) {
			result = API.makeTernary(SignalOperators.oppcas, idNode, caseNode, elseNode);
		}
		setASTAttribute(this, result);
		return result;
	}

} //CaseProcessImpl
