/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.pop.ssme.ConditionedDependence;
import org.eclipse.pop.ssme.ExprSignal;
import org.eclipse.pop.ssme.Signals;
import org.eclipse.pop.ssme.SsmePackage;
import org.eclipse.pop.ssme.polychrony.PKTrees;
import org.eclipse.pop.ssme.polychrony.PkPlugin;
import org.eclipse.pop.ssme.polychrony.SignalOperators;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Conditioned Dependence</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.impl.ConditionedDependenceImpl#getSignalsFrom <em>Signals From</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.impl.ConditionedDependenceImpl#getSignalsTo <em>Signals To</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.impl.ConditionedDependenceImpl#getConditionExpr <em>Condition Expr</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ConditionedDependenceImpl extends SignalElementImpl implements ConditionedDependence {
	/**
	 * The cached value of the '{@link #getSignalsFrom() <em>Signals From</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSignalsFrom()
	 * @generated
	 * @ordered
	 */
	protected Signals signalsFrom;

	/**
	 * The cached value of the '{@link #getSignalsTo() <em>Signals To</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSignalsTo()
	 * @generated
	 * @ordered
	 */
	protected Signals signalsTo;

	/**
	 * The cached value of the '{@link #getConditionExpr() <em>Condition Expr</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getConditionExpr()
	 * @generated
	 * @ordered
	 */
	protected ExprSignal conditionExpr;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ConditionedDependenceImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SsmePackage.eINSTANCE.getConditionedDependence();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Signals getSignalsFrom() {
		return signalsFrom;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSignalsFrom(Signals newSignalsFrom, NotificationChain msgs) {
		Signals oldSignalsFrom = signalsFrom;
		signalsFrom = newSignalsFrom;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.CONDITIONED_DEPENDENCE__SIGNALS_FROM, oldSignalsFrom, newSignalsFrom);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSignalsFrom(Signals newSignalsFrom) {
		if (newSignalsFrom != signalsFrom) {
			NotificationChain msgs = null;
			if (signalsFrom != null)
				msgs = ((InternalEObject)signalsFrom).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.CONDITIONED_DEPENDENCE__SIGNALS_FROM, null, msgs);
			if (newSignalsFrom != null)
				msgs = ((InternalEObject)newSignalsFrom).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.CONDITIONED_DEPENDENCE__SIGNALS_FROM, null, msgs);
			msgs = basicSetSignalsFrom(newSignalsFrom, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.CONDITIONED_DEPENDENCE__SIGNALS_FROM, newSignalsFrom, newSignalsFrom));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Signals getSignalsTo() {
		return signalsTo;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSignalsTo(Signals newSignalsTo, NotificationChain msgs) {
		Signals oldSignalsTo = signalsTo;
		signalsTo = newSignalsTo;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.CONDITIONED_DEPENDENCE__SIGNALS_TO, oldSignalsTo, newSignalsTo);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSignalsTo(Signals newSignalsTo) {
		if (newSignalsTo != signalsTo) {
			NotificationChain msgs = null;
			if (signalsTo != null)
				msgs = ((InternalEObject)signalsTo).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.CONDITIONED_DEPENDENCE__SIGNALS_TO, null, msgs);
			if (newSignalsTo != null)
				msgs = ((InternalEObject)newSignalsTo).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.CONDITIONED_DEPENDENCE__SIGNALS_TO, null, msgs);
			msgs = basicSetSignalsTo(newSignalsTo, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.CONDITIONED_DEPENDENCE__SIGNALS_TO, newSignalsTo, newSignalsTo));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ExprSignal getConditionExpr() {
		return conditionExpr;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetConditionExpr(ExprSignal newConditionExpr, NotificationChain msgs) {
		ExprSignal oldConditionExpr = conditionExpr;
		conditionExpr = newConditionExpr;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.CONDITIONED_DEPENDENCE__CONDITION_EXPR, oldConditionExpr, newConditionExpr);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setConditionExpr(ExprSignal newConditionExpr) {
		if (newConditionExpr != conditionExpr) {
			NotificationChain msgs = null;
			if (conditionExpr != null)
				msgs = ((InternalEObject)conditionExpr).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.CONDITIONED_DEPENDENCE__CONDITION_EXPR, null, msgs);
			if (newConditionExpr != null)
				msgs = ((InternalEObject)newConditionExpr).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.CONDITIONED_DEPENDENCE__CONDITION_EXPR, null, msgs);
			msgs = basicSetConditionExpr(newConditionExpr, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.CONDITIONED_DEPENDENCE__CONDITION_EXPR, newConditionExpr, newConditionExpr));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case SsmePackage.CONDITIONED_DEPENDENCE__SIGNALS_FROM:
				return basicSetSignalsFrom(null, msgs);
			case SsmePackage.CONDITIONED_DEPENDENCE__SIGNALS_TO:
				return basicSetSignalsTo(null, msgs);
			case SsmePackage.CONDITIONED_DEPENDENCE__CONDITION_EXPR:
				return basicSetConditionExpr(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SsmePackage.CONDITIONED_DEPENDENCE__SIGNALS_FROM:
				return getSignalsFrom();
			case SsmePackage.CONDITIONED_DEPENDENCE__SIGNALS_TO:
				return getSignalsTo();
			case SsmePackage.CONDITIONED_DEPENDENCE__CONDITION_EXPR:
				return getConditionExpr();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SsmePackage.CONDITIONED_DEPENDENCE__SIGNALS_FROM:
				setSignalsFrom((Signals)newValue);
				return;
			case SsmePackage.CONDITIONED_DEPENDENCE__SIGNALS_TO:
				setSignalsTo((Signals)newValue);
				return;
			case SsmePackage.CONDITIONED_DEPENDENCE__CONDITION_EXPR:
				setConditionExpr((ExprSignal)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SsmePackage.CONDITIONED_DEPENDENCE__SIGNALS_FROM:
				setSignalsFrom((Signals)null);
				return;
			case SsmePackage.CONDITIONED_DEPENDENCE__SIGNALS_TO:
				setSignalsTo((Signals)null);
				return;
			case SsmePackage.CONDITIONED_DEPENDENCE__CONDITION_EXPR:
				setConditionExpr((ExprSignal)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SsmePackage.CONDITIONED_DEPENDENCE__SIGNALS_FROM:
				return signalsFrom != null;
			case SsmePackage.CONDITIONED_DEPENDENCE__SIGNALS_TO:
				return signalsTo != null;
			case SsmePackage.CONDITIONED_DEPENDENCE__CONDITION_EXPR:
				return conditionExpr != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public long makeAST() {
		PKTrees API = PkPlugin.getTreeAPI();
		long result = PKTrees.ERROR_NODE;
		
		long signauxGNode = API.getNilTree();
		if (getSignalsFrom() != null) {
			signauxGNode = getSignalsFrom().makeAST();
		}
		
		long signauxDNode = API.getNilTree();
		if (getSignalsTo() != null) {
			signauxDNode = getSignalsTo().makeAST();
		}
		
		long whenExprNode = API.getNilTree();
		if (getConditionExpr() != null) {
			whenExprNode = getConditionExpr().makeAST();
		}
		
		if (signauxGNode != PKTrees.ERROR_NODE &&
				signauxDNode != PKTrees.ERROR_NODE &&
				whenExprNode != PKTrees.ERROR_NODE) {
			result = API.makeTernary(SignalOperators.opdepd, signauxGNode, signauxDNode, whenExprNode);
		}
		setASTAttribute(this, result);
		return result;
	}

} //ConditionedDependenceImpl
