/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.pop.ssme.ConstantDescription;
import org.eclipse.pop.ssme.ConstantDescriptionValue;
import org.eclipse.pop.ssme.Identifier;
import org.eclipse.pop.ssme.SsmePackage;
import org.eclipse.pop.ssme.polychrony.PKTrees;
import org.eclipse.pop.ssme.polychrony.PkPlugin;
import org.eclipse.pop.ssme.polychrony.SignalOperators;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Constant Description</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.impl.ConstantDescriptionImpl#getIdentifier <em>Identifier</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.impl.ConstantDescriptionImpl#getConstantDescriptionValue <em>Constant Description Value</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ConstantDescriptionImpl extends SignalElementImpl implements ConstantDescription {
	/**
	 * The cached value of the '{@link #getIdentifier() <em>Identifier</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIdentifier()
	 * @generated
	 * @ordered
	 */
	protected Identifier identifier;

	/**
	 * The cached value of the '{@link #getConstantDescriptionValue() <em>Constant Description Value</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getConstantDescriptionValue()
	 * @generated
	 * @ordered
	 */
	protected ConstantDescriptionValue constantDescriptionValue;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ConstantDescriptionImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SsmePackage.eINSTANCE.getConstantDescription();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Identifier getIdentifier() {
		return identifier;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetIdentifier(Identifier newIdentifier, NotificationChain msgs) {
		Identifier oldIdentifier = identifier;
		identifier = newIdentifier;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.CONSTANT_DESCRIPTION__IDENTIFIER, oldIdentifier, newIdentifier);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIdentifier(Identifier newIdentifier) {
		if (newIdentifier != identifier) {
			NotificationChain msgs = null;
			if (identifier != null)
				msgs = ((InternalEObject)identifier).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.CONSTANT_DESCRIPTION__IDENTIFIER, null, msgs);
			if (newIdentifier != null)
				msgs = ((InternalEObject)newIdentifier).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.CONSTANT_DESCRIPTION__IDENTIFIER, null, msgs);
			msgs = basicSetIdentifier(newIdentifier, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.CONSTANT_DESCRIPTION__IDENTIFIER, newIdentifier, newIdentifier));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ConstantDescriptionValue getConstantDescriptionValue() {
		return constantDescriptionValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetConstantDescriptionValue(ConstantDescriptionValue newConstantDescriptionValue, NotificationChain msgs) {
		ConstantDescriptionValue oldConstantDescriptionValue = constantDescriptionValue;
		constantDescriptionValue = newConstantDescriptionValue;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.CONSTANT_DESCRIPTION__CONSTANT_DESCRIPTION_VALUE, oldConstantDescriptionValue, newConstantDescriptionValue);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setConstantDescriptionValue(ConstantDescriptionValue newConstantDescriptionValue) {
		if (newConstantDescriptionValue != constantDescriptionValue) {
			NotificationChain msgs = null;
			if (constantDescriptionValue != null)
				msgs = ((InternalEObject)constantDescriptionValue).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.CONSTANT_DESCRIPTION__CONSTANT_DESCRIPTION_VALUE, null, msgs);
			if (newConstantDescriptionValue != null)
				msgs = ((InternalEObject)newConstantDescriptionValue).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.CONSTANT_DESCRIPTION__CONSTANT_DESCRIPTION_VALUE, null, msgs);
			msgs = basicSetConstantDescriptionValue(newConstantDescriptionValue, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.CONSTANT_DESCRIPTION__CONSTANT_DESCRIPTION_VALUE, newConstantDescriptionValue, newConstantDescriptionValue));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case SsmePackage.CONSTANT_DESCRIPTION__IDENTIFIER:
				return basicSetIdentifier(null, msgs);
			case SsmePackage.CONSTANT_DESCRIPTION__CONSTANT_DESCRIPTION_VALUE:
				return basicSetConstantDescriptionValue(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SsmePackage.CONSTANT_DESCRIPTION__IDENTIFIER:
				return getIdentifier();
			case SsmePackage.CONSTANT_DESCRIPTION__CONSTANT_DESCRIPTION_VALUE:
				return getConstantDescriptionValue();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SsmePackage.CONSTANT_DESCRIPTION__IDENTIFIER:
				setIdentifier((Identifier)newValue);
				return;
			case SsmePackage.CONSTANT_DESCRIPTION__CONSTANT_DESCRIPTION_VALUE:
				setConstantDescriptionValue((ConstantDescriptionValue)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SsmePackage.CONSTANT_DESCRIPTION__IDENTIFIER:
				setIdentifier((Identifier)null);
				return;
			case SsmePackage.CONSTANT_DESCRIPTION__CONSTANT_DESCRIPTION_VALUE:
				setConstantDescriptionValue((ConstantDescriptionValue)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SsmePackage.CONSTANT_DESCRIPTION__IDENTIFIER:
				return identifier != null;
			case SsmePackage.CONSTANT_DESCRIPTION__CONSTANT_DESCRIPTION_VALUE:
				return constantDescriptionValue != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public long makeAST() {
		PKTrees API = PkPlugin.getTreeAPI();
		long result = PKTrees.ERROR_NODE;
		
		long identNode = API.getNilTree();
		if (getIdentifier() != null) {
			identNode = getIdentifier().makeAST();
		}
		
		long constantValueNode = API.getNilTree();
		if (getConstantDescriptionValue() != null) {
			constantValueNode = getConstantDescriptionValue().makeAST();
		}
		
		if (identNode != PKTrees.ERROR_NODE && constantValueNode != PKTrees.ERROR_NODE) {
			result = API.makeBinary(SignalOperators.opcons, identNode, constantValueNode);
		}
		setASTAttribute(this, result);
		return result;
	}

} //ConstantDescriptionImpl
