/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.pop.ssme.ConstantLogical;
import org.eclipse.pop.ssme.ConstantLogicalKind;
import org.eclipse.pop.ssme.SsmePackage;
import org.eclipse.pop.ssme.polychrony.PKTrees;
import org.eclipse.pop.ssme.polychrony.PkPlugin;
import org.eclipse.pop.ssme.polychrony.SignalOperators;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Constant Logical</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.impl.ConstantLogicalImpl#getConstantLogicalKind <em>Constant Logical Kind</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ConstantLogicalImpl extends SignalElementImpl implements ConstantLogical {
	/**
	 * The default value of the '{@link #getConstantLogicalKind() <em>Constant Logical Kind</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getConstantLogicalKind()
	 * @generated
	 * @ordered
	 */
	protected static final ConstantLogicalKind CONSTANT_LOGICAL_KIND_EDEFAULT = ConstantLogicalKind.TRUE_LITERAL;

	/**
	 * The cached value of the '{@link #getConstantLogicalKind() <em>Constant Logical Kind</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getConstantLogicalKind()
	 * @generated
	 * @ordered
	 */
	protected ConstantLogicalKind constantLogicalKind = CONSTANT_LOGICAL_KIND_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ConstantLogicalImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SsmePackage.eINSTANCE.getConstantLogical();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ConstantLogicalKind getConstantLogicalKind() {
		return constantLogicalKind;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setConstantLogicalKind(ConstantLogicalKind newConstantLogicalKind) {
		ConstantLogicalKind oldConstantLogicalKind = constantLogicalKind;
		constantLogicalKind = newConstantLogicalKind == null ? CONSTANT_LOGICAL_KIND_EDEFAULT : newConstantLogicalKind;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.CONSTANT_LOGICAL__CONSTANT_LOGICAL_KIND, oldConstantLogicalKind, constantLogicalKind));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public long makeAST() {
		PKTrees API = PkPlugin.getTreeAPI();
		long result = API.getNilTree();
		if (getConstantLogicalKind().equals(ConstantLogicalKind.TRUE_LITERAL)) {
			result = API.makeNullary(SignalOperators.optrue);
		}
		else if (getConstantLogicalKind().equals(ConstantLogicalKind.FALSE_LITERAL)) {
			result = API.makeNullary(SignalOperators.opfalse);
		}
		setASTAttribute(this, result);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SsmePackage.CONSTANT_LOGICAL__CONSTANT_LOGICAL_KIND:
				return getConstantLogicalKind();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SsmePackage.CONSTANT_LOGICAL__CONSTANT_LOGICAL_KIND:
				setConstantLogicalKind((ConstantLogicalKind)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SsmePackage.CONSTANT_LOGICAL__CONSTANT_LOGICAL_KIND:
				setConstantLogicalKind(CONSTANT_LOGICAL_KIND_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SsmePackage.CONSTANT_LOGICAL__CONSTANT_LOGICAL_KIND:
				return constantLogicalKind != CONSTANT_LOGICAL_KIND_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (constantLogicalKind: ");
		result.append(constantLogicalKind);
		result.append(')');
		return result.toString();
	}

} //ConstantLogicalImpl
