/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.pop.ssme.ConstantString;
import org.eclipse.pop.ssme.SsmePackage;
import org.eclipse.pop.ssme.polychrony.PKTrees;
import org.eclipse.pop.ssme.polychrony.PkPlugin;
import org.eclipse.pop.ssme.polychrony.traceability.ErrorMessages;
import org.eclipse.pop.ssme.polychrony.utils.PolychronyDiagnostic;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Constant String</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.impl.ConstantStringImpl#getAtomString <em>Atom String</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ConstantStringImpl extends SignalElementImpl implements ConstantString {
	/**
	 * The default value of the '{@link #getAtomString() <em>Atom String</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAtomString()
	 * @generated
	 * @ordered
	 */
	protected static final String ATOM_STRING_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getAtomString() <em>Atom String</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAtomString()
	 * @generated
	 * @ordered
	 */
	protected String atomString = ATOM_STRING_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ConstantStringImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SsmePackage.eINSTANCE.getConstantString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getAtomString() {
		return atomString;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAtomString(String newAtomString) {
		String oldAtomString = atomString;
		atomString = newAtomString;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.CONSTANT_STRING__ATOM_STRING, oldAtomString, atomString));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public long makeAST() {
		PKTrees API = PkPlugin.getTreeAPI();
		long result = API.getNilTree();
		if (getAtomString() != null) {
			result = PkPlugin.getParser().parseString( "\"" + atomString + "\"");
		}
		if (result == PKTrees.ERROR_NODE) {
			PolychronyDiagnostic.add(Diagnostic.ERROR, ErrorMessages.INCORRECT_NAME + atomString, this);
		}
		setASTAttribute(this, result);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SsmePackage.CONSTANT_STRING__ATOM_STRING:
				return getAtomString();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SsmePackage.CONSTANT_STRING__ATOM_STRING:
				setAtomString((String)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SsmePackage.CONSTANT_STRING__ATOM_STRING:
				setAtomString(ATOM_STRING_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SsmePackage.CONSTANT_STRING__ATOM_STRING:
				return ATOM_STRING_EDEFAULT == null ? atomString != null : !ATOM_STRING_EDEFAULT.equals(atomString);
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (atomString: ");
		result.append(atomString);
		result.append(')');
		return result.toString();
	}

} //ConstantStringImpl
