/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.pop.ssme.ConstantDefinition;
import org.eclipse.pop.ssme.ConstantsDeclaration;
import org.eclipse.pop.ssme.SsmePackage;
import org.eclipse.pop.ssme.Type;
import org.eclipse.pop.ssme.VisibilityKind;
import org.eclipse.pop.ssme.polychrony.PKTrees;
import org.eclipse.pop.ssme.polychrony.PkPlugin;
import org.eclipse.pop.ssme.polychrony.SignalOperators;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Constants Declaration</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.impl.ConstantsDeclarationImpl#getVisibility <em>Visibility</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.impl.ConstantsDeclarationImpl#getType <em>Type</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.impl.ConstantsDeclarationImpl#getListConstantDefinition <em>List Constant Definition</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ConstantsDeclarationImpl extends SignalElementImpl implements ConstantsDeclaration {
	/**
	 * The default value of the '{@link #getVisibility() <em>Visibility</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVisibility()
	 * @generated
	 * @ordered
	 */
	protected static final VisibilityKind VISIBILITY_EDEFAULT = VisibilityKind.PUBLIC_LITERAL;

	/**
	 * The cached value of the '{@link #getVisibility() <em>Visibility</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVisibility()
	 * @generated
	 * @ordered
	 */
	protected VisibilityKind visibility = VISIBILITY_EDEFAULT;

	/**
	 * The cached value of the '{@link #getType() <em>Type</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected Type type;

	/**
	 * The cached value of the '{@link #getListConstantDefinition() <em>List Constant Definition</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getListConstantDefinition()
	 * @generated
	 * @ordered
	 */
	protected EList<ConstantDefinition> listConstantDefinition;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ConstantsDeclarationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SsmePackage.eINSTANCE.getConstantsDeclaration();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public VisibilityKind getVisibility() {
		return visibility;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setVisibility(VisibilityKind newVisibility) {
		VisibilityKind oldVisibility = visibility;
		visibility = newVisibility == null ? VISIBILITY_EDEFAULT : newVisibility;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.CONSTANTS_DECLARATION__VISIBILITY, oldVisibility, visibility));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Type getType() {
		return type;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetType(Type newType, NotificationChain msgs) {
		Type oldType = type;
		type = newType;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.CONSTANTS_DECLARATION__TYPE, oldType, newType);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setType(Type newType) {
		if (newType != type) {
			NotificationChain msgs = null;
			if (type != null)
				msgs = ((InternalEObject)type).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.CONSTANTS_DECLARATION__TYPE, null, msgs);
			if (newType != null)
				msgs = ((InternalEObject)newType).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.CONSTANTS_DECLARATION__TYPE, null, msgs);
			msgs = basicSetType(newType, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.CONSTANTS_DECLARATION__TYPE, newType, newType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<ConstantDefinition> getListConstantDefinition() {
		if (listConstantDefinition == null) {
			listConstantDefinition = new EObjectContainmentEList<ConstantDefinition>(ConstantDefinition.class, this, SsmePackage.CONSTANTS_DECLARATION__LIST_CONSTANT_DEFINITION);
		}
		return listConstantDefinition;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case SsmePackage.CONSTANTS_DECLARATION__TYPE:
				return basicSetType(null, msgs);
			case SsmePackage.CONSTANTS_DECLARATION__LIST_CONSTANT_DEFINITION:
				return ((InternalEList<?>)getListConstantDefinition()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SsmePackage.CONSTANTS_DECLARATION__VISIBILITY:
				return getVisibility();
			case SsmePackage.CONSTANTS_DECLARATION__TYPE:
				return getType();
			case SsmePackage.CONSTANTS_DECLARATION__LIST_CONSTANT_DEFINITION:
				return getListConstantDefinition();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SsmePackage.CONSTANTS_DECLARATION__VISIBILITY:
				setVisibility((VisibilityKind)newValue);
				return;
			case SsmePackage.CONSTANTS_DECLARATION__TYPE:
				setType((Type)newValue);
				return;
			case SsmePackage.CONSTANTS_DECLARATION__LIST_CONSTANT_DEFINITION:
				getListConstantDefinition().clear();
				getListConstantDefinition().addAll((Collection<? extends ConstantDefinition>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SsmePackage.CONSTANTS_DECLARATION__VISIBILITY:
				setVisibility(VISIBILITY_EDEFAULT);
				return;
			case SsmePackage.CONSTANTS_DECLARATION__TYPE:
				setType((Type)null);
				return;
			case SsmePackage.CONSTANTS_DECLARATION__LIST_CONSTANT_DEFINITION:
				getListConstantDefinition().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SsmePackage.CONSTANTS_DECLARATION__VISIBILITY:
				return visibility != VISIBILITY_EDEFAULT;
			case SsmePackage.CONSTANTS_DECLARATION__TYPE:
				return type != null;
			case SsmePackage.CONSTANTS_DECLARATION__LIST_CONSTANT_DEFINITION:
				return listConstantDefinition != null && !listConstantDefinition.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (visibility: ");
		result.append(visibility);
		result.append(')');
		return result.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public long makeAST() {
		PKTrees API = PkPlugin.getTreeAPI();
		long result = PKTrees.ERROR_NODE;
		long typeNode = API.getNilTree();
		
		if (getType() != null) {
			typeNode = getType().makeAST();
		}
		else {
			typeNode = API.makeNullary(SignalOperators.opimplicit);
		}
		
		long defConstantesNode = API.getNilTree();
		
		if (getListConstantDefinition() != null && !getListConstantDefinition().isEmpty()) {
			defConstantesNode = API.makeEmptyList(SignalOperators.oplcons);
			for (ConstantDefinition defConstante : getListConstantDefinition()) {
				long node = defConstante.makeAST();
				if (node != PKTrees.ERROR_NODE) {
					defConstantesNode = API.post(defConstantesNode, node);
				}
				
			}
		}
		
		if (visibility.equals(VisibilityKind.PRIVATE_LITERAL)) {
			result = API.makeBinary(SignalOperators.opdecconp, typeNode, defConstantesNode);
		}
		else if (visibility.equals(VisibilityKind.PUBLIC_LITERAL)) {
			result = API.makeBinary(SignalOperators.opdeccon, typeNode, defConstantesNode);
		}
		setASTAttribute(this, result);
		return result;
	}

} //ConstantsDeclarationImpl
