/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.pop.ssme.ElemDefinitionEnumeration;
import org.eclipse.pop.ssme.ListExprSignal;
import org.eclipse.pop.ssme.SsmePackage;
import org.eclipse.pop.ssme.polychrony.PKTrees;
import org.eclipse.pop.ssme.polychrony.PkPlugin;
import org.eclipse.pop.ssme.polychrony.SignalOperators;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Elem Definition Enumeration</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.impl.ElemDefinitionEnumerationImpl#getListExprSignal <em>List Expr Signal</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ElemDefinitionEnumerationImpl extends SignalElementImpl implements ElemDefinitionEnumeration {
	/**
	 * The cached value of the '{@link #getListExprSignal() <em>List Expr Signal</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getListExprSignal()
	 * @generated
	 * @ordered
	 */
	protected ListExprSignal listExprSignal;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ElemDefinitionEnumerationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SsmePackage.eINSTANCE.getElemDefinitionEnumeration();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ListExprSignal getListExprSignal() {
		return listExprSignal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetListExprSignal(ListExprSignal newListExprSignal, NotificationChain msgs) {
		ListExprSignal oldListExprSignal = listExprSignal;
		listExprSignal = newListExprSignal;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.ELEM_DEFINITION_ENUMERATION__LIST_EXPR_SIGNAL, oldListExprSignal, newListExprSignal);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setListExprSignal(ListExprSignal newListExprSignal) {
		if (newListExprSignal != listExprSignal) {
			NotificationChain msgs = null;
			if (listExprSignal != null)
				msgs = ((InternalEObject)listExprSignal).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.ELEM_DEFINITION_ENUMERATION__LIST_EXPR_SIGNAL, null, msgs);
			if (newListExprSignal != null)
				msgs = ((InternalEObject)newListExprSignal).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.ELEM_DEFINITION_ENUMERATION__LIST_EXPR_SIGNAL, null, msgs);
			msgs = basicSetListExprSignal(newListExprSignal, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.ELEM_DEFINITION_ENUMERATION__LIST_EXPR_SIGNAL, newListExprSignal, newListExprSignal));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case SsmePackage.ELEM_DEFINITION_ENUMERATION__LIST_EXPR_SIGNAL:
				return basicSetListExprSignal(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SsmePackage.ELEM_DEFINITION_ENUMERATION__LIST_EXPR_SIGNAL:
				return getListExprSignal();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SsmePackage.ELEM_DEFINITION_ENUMERATION__LIST_EXPR_SIGNAL:
				setListExprSignal((ListExprSignal)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SsmePackage.ELEM_DEFINITION_ENUMERATION__LIST_EXPR_SIGNAL:
				setListExprSignal((ListExprSignal)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SsmePackage.ELEM_DEFINITION_ENUMERATION__LIST_EXPR_SIGNAL:
				return listExprSignal != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public long makeAST() {
		PKTrees API = PkPlugin.getTreeAPI();
		long result = PKTrees.ERROR_NODE;
		long listExprSignalNode = API.getNilTree();
		if (getListExprSignal() != null && !getListExprSignal().getExprSignal().isEmpty()) {
			listExprSignalNode = getListExprSignal().makeAST();
		}
		
		if (listExprSignalNode != PKTrees.ERROR_NODE) {
			result = API.makeUnary(SignalOperators.oplevect, listExprSignalNode);
		}
		setASTAttribute(this, result);
		return result;
	}

} //ElemDefinitionEnumerationImpl
