/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.pop.ssme.FormalProcess;
import org.eclipse.pop.ssme.Identifier;
import org.eclipse.pop.ssme.ModelKind;
import org.eclipse.pop.ssme.SsmePackage;
import org.eclipse.pop.ssme.polychrony.PKTrees;
import org.eclipse.pop.ssme.polychrony.PkPlugin;
import org.eclipse.pop.ssme.polychrony.SignalOperators;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Formal Process</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.impl.FormalProcessImpl#getModelKind <em>Model Kind</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.impl.FormalProcessImpl#getModelType <em>Model Type</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.impl.FormalProcessImpl#getModelName <em>Model Name</em>}</li>
 * </ul>
 *
 * @generated
 */
public class FormalProcessImpl extends SignalElementImpl implements FormalProcess {
	/**
	 * The default value of the '{@link #getModelKind() <em>Model Kind</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getModelKind()
	 * @generated
	 * @ordered
	 */
	protected static final ModelKind MODEL_KIND_EDEFAULT = ModelKind.PROCESS_LITERAL;

	/**
	 * The cached value of the '{@link #getModelKind() <em>Model Kind</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getModelKind()
	 * @generated
	 * @ordered
	 */
	protected ModelKind modelKind = MODEL_KIND_EDEFAULT;

	/**
	 * The cached value of the '{@link #getModelType() <em>Model Type</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getModelType()
	 * @generated
	 * @ordered
	 */
	protected Identifier modelType;

	/**
	 * The cached value of the '{@link #getModelName() <em>Model Name</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getModelName()
	 * @generated
	 * @ordered
	 */
	protected Identifier modelName;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FormalProcessImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SsmePackage.eINSTANCE.getFormalProcess();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ModelKind getModelKind() {
		return modelKind;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setModelKind(ModelKind newModelKind) {
		ModelKind oldModelKind = modelKind;
		modelKind = newModelKind == null ? MODEL_KIND_EDEFAULT : newModelKind;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.FORMAL_PROCESS__MODEL_KIND, oldModelKind, modelKind));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Identifier getModelType() {
		return modelType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetModelType(Identifier newModelType, NotificationChain msgs) {
		Identifier oldModelType = modelType;
		modelType = newModelType;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.FORMAL_PROCESS__MODEL_TYPE, oldModelType, newModelType);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setModelType(Identifier newModelType) {
		if (newModelType != modelType) {
			NotificationChain msgs = null;
			if (modelType != null)
				msgs = ((InternalEObject)modelType).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.FORMAL_PROCESS__MODEL_TYPE, null, msgs);
			if (newModelType != null)
				msgs = ((InternalEObject)newModelType).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.FORMAL_PROCESS__MODEL_TYPE, null, msgs);
			msgs = basicSetModelType(newModelType, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.FORMAL_PROCESS__MODEL_TYPE, newModelType, newModelType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Identifier getModelName() {
		return modelName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetModelName(Identifier newModelName, NotificationChain msgs) {
		Identifier oldModelName = modelName;
		modelName = newModelName;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.FORMAL_PROCESS__MODEL_NAME, oldModelName, newModelName);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setModelName(Identifier newModelName) {
		if (newModelName != modelName) {
			NotificationChain msgs = null;
			if (modelName != null)
				msgs = ((InternalEObject)modelName).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.FORMAL_PROCESS__MODEL_NAME, null, msgs);
			if (newModelName != null)
				msgs = ((InternalEObject)newModelName).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.FORMAL_PROCESS__MODEL_NAME, null, msgs);
			msgs = basicSetModelName(newModelName, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.FORMAL_PROCESS__MODEL_NAME, newModelName, newModelName));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case SsmePackage.FORMAL_PROCESS__MODEL_TYPE:
				return basicSetModelType(null, msgs);
			case SsmePackage.FORMAL_PROCESS__MODEL_NAME:
				return basicSetModelName(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SsmePackage.FORMAL_PROCESS__MODEL_KIND:
				return getModelKind();
			case SsmePackage.FORMAL_PROCESS__MODEL_TYPE:
				return getModelType();
			case SsmePackage.FORMAL_PROCESS__MODEL_NAME:
				return getModelName();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SsmePackage.FORMAL_PROCESS__MODEL_KIND:
				setModelKind((ModelKind)newValue);
				return;
			case SsmePackage.FORMAL_PROCESS__MODEL_TYPE:
				setModelType((Identifier)newValue);
				return;
			case SsmePackage.FORMAL_PROCESS__MODEL_NAME:
				setModelName((Identifier)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SsmePackage.FORMAL_PROCESS__MODEL_KIND:
				setModelKind(MODEL_KIND_EDEFAULT);
				return;
			case SsmePackage.FORMAL_PROCESS__MODEL_TYPE:
				setModelType((Identifier)null);
				return;
			case SsmePackage.FORMAL_PROCESS__MODEL_NAME:
				setModelName((Identifier)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SsmePackage.FORMAL_PROCESS__MODEL_KIND:
				return modelKind != MODEL_KIND_EDEFAULT;
			case SsmePackage.FORMAL_PROCESS__MODEL_TYPE:
				return modelType != null;
			case SsmePackage.FORMAL_PROCESS__MODEL_NAME:
				return modelName != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (modelKind: ");
		result.append(modelKind);
		result.append(')');
		return result.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public long makeAST() {
		PKTrees API = PkPlugin.getTreeAPI();
		long result = PKTrees.ERROR_NODE;
		long id1Node = API.getNilTree();
		if (getModelType() != null) id1Node = getModelType().makeAST();
	 
		long id2Node = API.getNilTree();
		if (getModelName() != null)  id2Node = getModelName().makeAST();
		 
		if (id1Node != PKTrees.ERROR_NODE && id2Node != PKTrees.ERROR_NODE) {
			if (getModelKind().equals(ModelKind.PROCESS_LITERAL))  
				result = API.makeBinary(SignalOperators.opformproc, id1Node, id2Node);
			else if (getModelKind().equals(ModelKind.ACTION_LITERAL)) 
				result = API.makeBinary(SignalOperators.opformact, id1Node, id2Node); 
			else if (getModelKind().equals(ModelKind.NODE_LITERAL))  
				result = API.makeBinary(SignalOperators.opformnode, id1Node, id2Node); 
			else if (getModelKind().equals(ModelKind.FUNCTION_LITERAL)) 
				result = API.makeBinary(SignalOperators.opformfunc, id1Node, id2Node);	 
			else if (getModelKind().equals(ModelKind.PROCEDURE_LITERAL))  
				result = API.makeBinary(SignalOperators.opformprocedure, id1Node, id2Node); 
			else if (getModelKind().equals(ModelKind.AUTOMATON_LITERAL)) 
				result = API.makeBinary(SignalOperators.opformautomaton, id1Node, id2Node);		
		}
		setASTAttribute(this, result);
		return result;
	}

} //FormalProcessImpl
