/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.pop.ssme.Declaration;
import org.eclipse.pop.ssme.ModuleDescription;
import org.eclipse.pop.ssme.Pragma;
import org.eclipse.pop.ssme.SsmePackage;
import org.eclipse.pop.ssme.polychrony.PKTrees;
import org.eclipse.pop.ssme.polychrony.PkPlugin;
import org.eclipse.pop.ssme.polychrony.SignalOperators;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Module Description</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.impl.ModuleDescriptionImpl#getListPragma <em>List Pragma</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.impl.ModuleDescriptionImpl#getListDeclaration <em>List Declaration</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ModuleDescriptionImpl extends SignalElementImpl implements ModuleDescription {
	/**
	 * The cached value of the '{@link #getListPragma() <em>List Pragma</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getListPragma()
	 * @generated
	 * @ordered
	 */
	protected EList<Pragma> listPragma;

	/**
	 * The cached value of the '{@link #getListDeclaration() <em>List Declaration</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getListDeclaration()
	 * @generated
	 * @ordered
	 */
	protected EList<Declaration> listDeclaration;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ModuleDescriptionImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SsmePackage.eINSTANCE.getModuleDescription();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Pragma> getListPragma() {
		if (listPragma == null) {
			listPragma = new EObjectContainmentEList<Pragma>(Pragma.class, this, SsmePackage.MODULE_DESCRIPTION__LIST_PRAGMA);
		}
		return listPragma;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Declaration> getListDeclaration() {
		if (listDeclaration == null) {
			listDeclaration = new EObjectContainmentEList<Declaration>(Declaration.class, this, SsmePackage.MODULE_DESCRIPTION__LIST_DECLARATION);
		}
		return listDeclaration;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case SsmePackage.MODULE_DESCRIPTION__LIST_PRAGMA:
				return ((InternalEList<?>)getListPragma()).basicRemove(otherEnd, msgs);
			case SsmePackage.MODULE_DESCRIPTION__LIST_DECLARATION:
				return ((InternalEList<?>)getListDeclaration()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SsmePackage.MODULE_DESCRIPTION__LIST_PRAGMA:
				return getListPragma();
			case SsmePackage.MODULE_DESCRIPTION__LIST_DECLARATION:
				return getListDeclaration();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SsmePackage.MODULE_DESCRIPTION__LIST_PRAGMA:
				getListPragma().clear();
				getListPragma().addAll((Collection<? extends Pragma>)newValue);
				return;
			case SsmePackage.MODULE_DESCRIPTION__LIST_DECLARATION:
				getListDeclaration().clear();
				getListDeclaration().addAll((Collection<? extends Declaration>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SsmePackage.MODULE_DESCRIPTION__LIST_PRAGMA:
				getListPragma().clear();
				return;
			case SsmePackage.MODULE_DESCRIPTION__LIST_DECLARATION:
				getListDeclaration().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SsmePackage.MODULE_DESCRIPTION__LIST_PRAGMA:
				return listPragma != null && !listPragma.isEmpty();
			case SsmePackage.MODULE_DESCRIPTION__LIST_DECLARATION:
				return listDeclaration != null && !listDeclaration.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public long makeAST() {
		PKTrees API = PkPlugin.getTreeAPI();
		long result = PKTrees.ERROR_NODE;
		long pragmasNode = API.getNilTree();
		long declsNode = API.getNilTree();
		
		if (getListPragma() != null && !getListPragma().isEmpty()) {
			pragmasNode = API.makeEmptyList(SignalOperators.oplprag);
			for (Pragma pragma : getListPragma()) {
				long node = pragma.makeAST();
				if (node != PKTrees.ERROR_NODE) {
					pragmasNode = API.post(pragmasNode, node);
				}
			}
		}
		
		if (getListDeclaration() != null && !getListDeclaration().isEmpty()) {
			declsNode = API.makeEmptyList(SignalOperators.opldecl);
			for (Declaration decl : getListDeclaration()) {
				long declNode = decl.makeAST();
				if (declNode != PKTrees.ERROR_NODE) {
					declsNode = API.post(declsNode, declNode);
				}
			}
		}
		
		if (pragmasNode != PKTrees.ERROR_NODE && declsNode != PKTrees.ERROR_NODE) {
			result = API.makeBinary(SignalOperators.opdescmodu, pragmasNode, declsNode);
		}
		setASTAttribute(this, result);
		return result;
	}

} //ModuleDescriptionImpl
