/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.pop.ssme.Identifier;
import org.eclipse.pop.ssme.Module;
import org.eclipse.pop.ssme.ModuleDescription;
import org.eclipse.pop.ssme.SsmePackage;
import org.eclipse.pop.ssme.polychrony.PKTrees;
import org.eclipse.pop.ssme.polychrony.PkPlugin;
import org.eclipse.pop.ssme.polychrony.SignalOperators;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Module</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.impl.ModuleImpl#getIdentifier <em>Identifier</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.impl.ModuleImpl#getModuleDescription <em>Module Description</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ModuleImpl extends SignalElementImpl implements Module {
	/**
	 * The cached value of the '{@link #getIdentifier() <em>Identifier</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIdentifier()
	 * @generated
	 * @ordered
	 */
	protected Identifier identifier;

	/**
	 * The cached value of the '{@link #getModuleDescription() <em>Module Description</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getModuleDescription()
	 * @generated
	 * @ordered
	 */
	protected ModuleDescription moduleDescription;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ModuleImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SsmePackage.eINSTANCE.getModule();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Identifier getIdentifier() {
		return identifier;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetIdentifier(Identifier newIdentifier, NotificationChain msgs) {
		Identifier oldIdentifier = identifier;
		identifier = newIdentifier;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.MODULE__IDENTIFIER, oldIdentifier, newIdentifier);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIdentifier(Identifier newIdentifier) {
		if (newIdentifier != identifier) {
			NotificationChain msgs = null;
			if (identifier != null)
				msgs = ((InternalEObject)identifier).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.MODULE__IDENTIFIER, null, msgs);
			if (newIdentifier != null)
				msgs = ((InternalEObject)newIdentifier).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.MODULE__IDENTIFIER, null, msgs);
			msgs = basicSetIdentifier(newIdentifier, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.MODULE__IDENTIFIER, newIdentifier, newIdentifier));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ModuleDescription getModuleDescription() {
		return moduleDescription;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetModuleDescription(ModuleDescription newModuleDescription, NotificationChain msgs) {
		ModuleDescription oldModuleDescription = moduleDescription;
		moduleDescription = newModuleDescription;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.MODULE__MODULE_DESCRIPTION, oldModuleDescription, newModuleDescription);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setModuleDescription(ModuleDescription newModuleDescription) {
		if (newModuleDescription != moduleDescription) {
			NotificationChain msgs = null;
			if (moduleDescription != null)
				msgs = ((InternalEObject)moduleDescription).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.MODULE__MODULE_DESCRIPTION, null, msgs);
			if (newModuleDescription != null)
				msgs = ((InternalEObject)newModuleDescription).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.MODULE__MODULE_DESCRIPTION, null, msgs);
			msgs = basicSetModuleDescription(newModuleDescription, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.MODULE__MODULE_DESCRIPTION, newModuleDescription, newModuleDescription));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public long makeAST() {
		PKTrees API = PkPlugin.getTreeAPI();
		long result = PKTrees.ERROR_NODE;
		long idNode = API.getNilTree();
		if (getIdentifier() != null) {
			idNode = getIdentifier().makeAST();
		}
		long descriptionModuleNode = API.getNilTree();
		if (getModuleDescription() != null) {
			descriptionModuleNode = getModuleDescription().makeAST();
		}
		if (idNode != PKTrees.ERROR_NODE && descriptionModuleNode != PKTrees.ERROR_NODE) {
			result = API.makeBinary(SignalOperators.opmodu, idNode, descriptionModuleNode);
		}
		setASTAttribute(this, result);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case SsmePackage.MODULE__IDENTIFIER:
				return basicSetIdentifier(null, msgs);
			case SsmePackage.MODULE__MODULE_DESCRIPTION:
				return basicSetModuleDescription(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SsmePackage.MODULE__IDENTIFIER:
				return getIdentifier();
			case SsmePackage.MODULE__MODULE_DESCRIPTION:
				return getModuleDescription();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SsmePackage.MODULE__IDENTIFIER:
				setIdentifier((Identifier)newValue);
				return;
			case SsmePackage.MODULE__MODULE_DESCRIPTION:
				setModuleDescription((ModuleDescription)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SsmePackage.MODULE__IDENTIFIER:
				setIdentifier((Identifier)null);
				return;
			case SsmePackage.MODULE__MODULE_DESCRIPTION:
				setModuleDescription((ModuleDescription)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SsmePackage.MODULE__IDENTIFIER:
				return identifier != null;
			case SsmePackage.MODULE__MODULE_DESCRIPTION:
				return moduleDescription != null;
		}
		return super.eIsSet(featureID);
	}

} //ModuleImpl
