/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.pop.ssme.Operator;
import org.eclipse.pop.ssme.OperatorKind;
import org.eclipse.pop.ssme.SsmePackage;
import org.eclipse.pop.ssme.polychrony.PKTrees;
import org.eclipse.pop.ssme.polychrony.PkPlugin;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Operator</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.impl.OperatorImpl#getOperatorKind <em>Operator Kind</em>}</li>
 * </ul>
 *
 * @generated
 */
public class OperatorImpl extends SignalElementImpl implements Operator {
	/**
	 * The default value of the '{@link #getOperatorKind() <em>Operator Kind</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOperatorKind()
	 * @generated
	 * @ordered
	 */
	protected static final OperatorKind OPERATOR_KIND_EDEFAULT = OperatorKind.NULL_CLOCK_LITERAL;

	/**
	 * The cached value of the '{@link #getOperatorKind() <em>Operator Kind</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOperatorKind()
	 * @generated
	 * @ordered
	 */
	protected OperatorKind operatorKind = OPERATOR_KIND_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OperatorImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SsmePackage.eINSTANCE.getOperator();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OperatorKind getOperatorKind() {
		return operatorKind;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOperatorKind(OperatorKind newOperatorKind) {
		OperatorKind oldOperatorKind = operatorKind;
		operatorKind = newOperatorKind == null ? OPERATOR_KIND_EDEFAULT : newOperatorKind;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.OPERATOR__OPERATOR_KIND, oldOperatorKind, operatorKind));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public long makeAST() {
		PKTrees API = PkPlugin.getTreeAPI();
		long result = API.getNilTree();
		if (getOperatorKind().equals(OperatorKind.NULL_CLOCK_LITERAL)) {
			result = PkPlugin.getParser().parseOperator( "^0");
		}
		else if (getOperatorKind().equals(OperatorKind.NEXT_LITERAL)) {
			result = PkPlugin.getParser().parseOperator( "next");
		}
		else if (getOperatorKind().equals(OperatorKind.ARRAY_RESTRUCTURATION_LITERAL)) {
			result = PkPlugin.getParser().parseOperator( ":");
		}
		else if (getOperatorKind().equals(OperatorKind.DEFAULT_LITERAL)) {
			result = PkPlugin.getParser().parseOperator( "default");
		}
		else if (getOperatorKind().equals(OperatorKind.WHEN_LITERAL)) {
			result = PkPlugin.getParser().parseOperator( "when");
		}
		else if (getOperatorKind().equals(OperatorKind.AFTER_LITERAL)) {
			result = PkPlugin.getParser().parseOperator( "after");
		}
		else if (getOperatorKind().equals(OperatorKind.FROM_LITERAL)) {
			result = PkPlugin.getParser().parseOperator( "from");
		}
		else if (getOperatorKind().equals(OperatorKind.COUNT_LITERAL)) {
			result = PkPlugin.getParser().parseOperator( "count");
		}
		else if (getOperatorKind().equals(OperatorKind.CLOCK_UNION_LITERAL)) {
			result = PkPlugin.getParser().parseOperator( "^+");
		}
		else if (getOperatorKind().equals(OperatorKind.CLOCK_DIFFERENCE_LITERAL)) {
			result = PkPlugin.getParser().parseOperator( "^-");
		}
		else if (getOperatorKind().equals(OperatorKind.CLOCK_PRODUCT_LITERAL)) {
			result = PkPlugin.getParser().parseOperator( "^*");
		}
		else if (getOperatorKind().equals(OperatorKind.IF_LITERAL)) {
			result = PkPlugin.getParser().parseOperator( "if");
		}
		else if (getOperatorKind().equals(OperatorKind.EXPR_INDEX_LITERAL)) {
			result = PkPlugin.getParser().parseOperator( "..");
		}
		else if (getOperatorKind().equals(OperatorKind.XOR_LITERAL)) {
			result = PkPlugin.getParser().parseOperator( "xor");
		}
		else if (getOperatorKind().equals(OperatorKind.OR_LITERAL)) {
			result = PkPlugin.getParser().parseOperator( "or");
		}
		else if (getOperatorKind().equals(OperatorKind.AND_LITERAL)) {
			result = PkPlugin.getParser().parseOperator( "and");
		}
		else if (getOperatorKind().equals(OperatorKind.NOT_LITERAL)) {
			result = PkPlugin.getParser().parseOperator( "not");
		}
		else if (getOperatorKind().equals(OperatorKind.EQUAL_EQUAL_LITERAL)) {
			result = PkPlugin.getParser().parseOperator( "==");
		}
		else if (getOperatorKind().equals(OperatorKind.LESS_LESS_EQUAL_LITERAL)) {
			result = PkPlugin.getParser().parseOperator( "<<=");
		}
		else if (getOperatorKind().equals(OperatorKind.EQUAL_LITERAL)) {
			result = PkPlugin.getParser().parseOperator( "=");
		}
		else if (getOperatorKind().equals(OperatorKind.NOT_EQUAL_LITERAL)) {
			result = PkPlugin.getParser().parseOperator( "/=");
		}
		else if (getOperatorKind().equals(OperatorKind.GREATER_LITERAL)) {
			result = PkPlugin.getParser().parseOperator( ">");
		}
		else if (getOperatorKind().equals(OperatorKind.GREATER_OR_EQUAL_LITERAL)) {
			result = PkPlugin.getParser().parseOperator( ">=");
		}
		else if (getOperatorKind().equals(OperatorKind.LESS_LITERAL)) {
			result = PkPlugin.getParser().parseOperator( "<");
		}
		else if (getOperatorKind().equals(OperatorKind.LESS_OR_EQUAL_LITERAL)) {
			result = PkPlugin.getParser().parseOperator( "<=");
		}
		else if (getOperatorKind().equals(OperatorKind.ADD_LITERAL)) {
			result = PkPlugin.getParser().parseOperator( "+");
		}
		else if (getOperatorKind().equals(OperatorKind.MINUS_LITERAL)) {
			result = PkPlugin.getParser().parseOperator( "-");
		}
		else if (getOperatorKind().equals(OperatorKind.CONCATENATION_LITERAL)) {
			result = PkPlugin.getParser().parseOperator( "|+");
		}
		else if (getOperatorKind().equals(OperatorKind.PRODUCT_LITERAL)) {
			result = PkPlugin.getParser().parseOperator( "*");
		}
		else if (getOperatorKind().equals(OperatorKind.ARRAY_PRODUCT_LITERAL)) {
			result = PkPlugin.getParser().parseOperator( "*.");
		}
		else if (getOperatorKind().equals(OperatorKind.DIV_LITERAL)) {
			result = PkPlugin.getParser().parseOperator( "/");
		}
		else if (getOperatorKind().equals(OperatorKind.MODULO_LITERAL)) {
			result = PkPlugin.getParser().parseOperator( "modulo");
		}
		else if (getOperatorKind().equals(OperatorKind.REPETITION_LITERAL)) {
			result = PkPlugin.getParser().parseOperator( "|*");
		}
		else if (getOperatorKind().equals(OperatorKind.POWER_LITERAL)) {
			result = PkPlugin.getParser().parseOperator( "**");
		}
		else if (getOperatorKind().equals(OperatorKind.COMPLEX_CONSTRUCTOR_LITERAL)) {
			result = PkPlugin.getParser().parseOperator( "@");
		}
		else if (getOperatorKind().equals(OperatorKind.CELL_LITERAL)) {
			result = PkPlugin.getParser().parseOperator( "cell");
		}
		else if (getOperatorKind().equals(OperatorKind.VAR_LITERAL)) {
			result = PkPlugin.getParser().parseOperator( "var");
		}
		else if (getOperatorKind().equals(OperatorKind.DELAY_LITERAL)) {
			result = PkPlugin.getParser().parseOperator( "$");
		}
		else if (getOperatorKind().equals(OperatorKind.WINDOW_LITERAL)) {
			result = PkPlugin.getParser().parseOperator( "window");
		}
		else if (getOperatorKind().equals(OperatorKind.TR_LITERAL)) {
			result = PkPlugin.getParser().parseOperator( "tr");
		}
		else if (getOperatorKind().equals(OperatorKind.RECUPERATION_LITERAL)) {
			result = PkPlugin.getParser().parseOperator( "\\\\");
		}
		else if (getOperatorKind().equals(OperatorKind.CLOCK_LITERAL)) {
			result = PkPlugin.getParser().parseOperator( "^");
		}
		else if (getOperatorKind().equals(OperatorKind.EVENT_LITERAL)) {
			result = PkPlugin.getParser().parseOperator( "event");
		}
		else if (getOperatorKind().equals(OperatorKind.BOOLEAN_LITERAL)) {
			result = PkPlugin.getParser().parseOperator( "boolean");
		}
		else if (getOperatorKind().equals(OperatorKind.SHORT_LITERAL)) {
			result = PkPlugin.getParser().parseOperator( "short");
		}
		else if (getOperatorKind().equals(OperatorKind.INTEGER_LITERAL)) {
			result = PkPlugin.getParser().parseOperator( "integer");
		}
		else if (getOperatorKind().equals(OperatorKind.LONG_LITERAL)) {
			result = PkPlugin.getParser().parseOperator( "long");
		}
		else if (getOperatorKind().equals(OperatorKind.REAL_LITERAL)) {
			result = PkPlugin.getParser().parseOperator( "real");
		}
		else if (getOperatorKind().equals(OperatorKind.DREAL_LITERAL)) {
			result = PkPlugin.getParser().parseOperator( "dreal");
		}
		else if (getOperatorKind().equals(OperatorKind.COMPLEX_LITERAL)) {
			result = PkPlugin.getParser().parseOperator( "complex");
		}
		else if (getOperatorKind().equals(OperatorKind.DCOMPLEX_LITERAL)) {
			result = PkPlugin.getParser().parseOperator( "dcomplex");
		}
		else if (getOperatorKind().equals(OperatorKind.CHAR_LITERAL)) {
			result = PkPlugin.getParser().parseOperator( "char");
		}
		else if (getOperatorKind().equals(OperatorKind.STRING_LITERAL)) {
			result = PkPlugin.getParser().parseOperator( "string");
		}
		else if (getOperatorKind().equals(OperatorKind.FALSE_LITERAL)) {
			result = PkPlugin.getParser().parseOperator( "false");
		}
		else if (getOperatorKind().equals(OperatorKind.TRUE_LITERAL)) {
			result = PkPlugin.getParser().parseOperator( "true");
		}
		setASTAttribute(this, result);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SsmePackage.OPERATOR__OPERATOR_KIND:
				return getOperatorKind();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SsmePackage.OPERATOR__OPERATOR_KIND:
				setOperatorKind((OperatorKind)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SsmePackage.OPERATOR__OPERATOR_KIND:
				setOperatorKind(OPERATOR_KIND_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SsmePackage.OPERATOR__OPERATOR_KIND:
				return operatorKind != OPERATOR_KIND_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (operatorKind: ");
		result.append(operatorKind);
		result.append(')');
		return result.toString();
	}

} //OperatorImpl
