/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.pop.ssme.Identifier;
import org.eclipse.pop.ssme.Pragma;
import org.eclipse.pop.ssme.SsmePackage;
import org.eclipse.pop.ssme.StringValue;
import org.eclipse.pop.ssme.polychrony.PKTrees;
import org.eclipse.pop.ssme.polychrony.PkPlugin;
import org.eclipse.pop.ssme.polychrony.SignalOperators;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Pragma</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.impl.PragmaImpl#getIdentifier <em>Identifier</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.impl.PragmaImpl#getListPragmaObject <em>List Pragma Object</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.impl.PragmaImpl#getPragmaStatement <em>Pragma Statement</em>}</li>
 * </ul>
 *
 * @generated
 */
public class PragmaImpl extends SignalElementImpl implements Pragma {
	/**
	 * The cached value of the '{@link #getIdentifier() <em>Identifier</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIdentifier()
	 * @generated
	 * @ordered
	 */
	protected Identifier identifier;

	/**
	 * The cached value of the '{@link #getListPragmaObject() <em>List Pragma Object</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getListPragmaObject()
	 * @generated
	 * @ordered
	 */
	protected EList<Identifier> listPragmaObject;

	/**
	 * The cached value of the '{@link #getPragmaStatement() <em>Pragma Statement</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPragmaStatement()
	 * @generated
	 * @ordered
	 */
	protected StringValue pragmaStatement;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PragmaImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SsmePackage.eINSTANCE.getPragma();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Identifier getIdentifier() {
		return identifier;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetIdentifier(Identifier newIdentifier, NotificationChain msgs) {
		Identifier oldIdentifier = identifier;
		identifier = newIdentifier;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.PRAGMA__IDENTIFIER, oldIdentifier, newIdentifier);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIdentifier(Identifier newIdentifier) {
		if (newIdentifier != identifier) {
			NotificationChain msgs = null;
			if (identifier != null)
				msgs = ((InternalEObject)identifier).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.PRAGMA__IDENTIFIER, null, msgs);
			if (newIdentifier != null)
				msgs = ((InternalEObject)newIdentifier).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.PRAGMA__IDENTIFIER, null, msgs);
			msgs = basicSetIdentifier(newIdentifier, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.PRAGMA__IDENTIFIER, newIdentifier, newIdentifier));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Identifier> getListPragmaObject() {
		if (listPragmaObject == null) {
			listPragmaObject = new EObjectContainmentEList<Identifier>(Identifier.class, this, SsmePackage.PRAGMA__LIST_PRAGMA_OBJECT);
		}
		return listPragmaObject;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public StringValue getPragmaStatement() {
		return pragmaStatement;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetPragmaStatement(StringValue newPragmaStatement, NotificationChain msgs) {
		StringValue oldPragmaStatement = pragmaStatement;
		pragmaStatement = newPragmaStatement;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.PRAGMA__PRAGMA_STATEMENT, oldPragmaStatement, newPragmaStatement);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPragmaStatement(StringValue newPragmaStatement) {
		if (newPragmaStatement != pragmaStatement) {
			NotificationChain msgs = null;
			if (pragmaStatement != null)
				msgs = ((InternalEObject)pragmaStatement).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.PRAGMA__PRAGMA_STATEMENT, null, msgs);
			if (newPragmaStatement != null)
				msgs = ((InternalEObject)newPragmaStatement).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.PRAGMA__PRAGMA_STATEMENT, null, msgs);
			msgs = basicSetPragmaStatement(newPragmaStatement, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.PRAGMA__PRAGMA_STATEMENT, newPragmaStatement, newPragmaStatement));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public long makeAST() {
		PKTrees API = PkPlugin.getTreeAPI();
		long result = PKTrees.ERROR_NODE;
		
		long idNode = API.getNilTree();
		if (getIdentifier() != null) {
			idNode = getIdentifier().makeAST(); 
		}
		
		long objPragmaNode = API.getNilTree();
		if (getListPragmaObject() != null && !getListPragmaObject().isEmpty()) {
			objPragmaNode = API.makeEmptyList(SignalOperators.oplopra);
			for (Identifier id : getListPragmaObject()) {
				long node = id.makeAST();
				if (node != PKTrees.ERROR_NODE) {
					objPragmaNode = API.post(objPragmaNode, node);
				}
				
			}
		}
		
		long chaineNode = API.getNilTree();
		if (getPragmaStatement() != null) {
			chaineNode = getPragmaStatement().makeAST();
		}
		
		if (idNode != PKTrees.ERROR_NODE &&
				objPragmaNode != PKTrees.ERROR_NODE &&
				chaineNode != PKTrees.ERROR_NODE) {
			result = API.makeTernary(SignalOperators.opprag, idNode, objPragmaNode, chaineNode);
		}
		setASTAttribute(this, result);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case SsmePackage.PRAGMA__IDENTIFIER:
				return basicSetIdentifier(null, msgs);
			case SsmePackage.PRAGMA__LIST_PRAGMA_OBJECT:
				return ((InternalEList<?>)getListPragmaObject()).basicRemove(otherEnd, msgs);
			case SsmePackage.PRAGMA__PRAGMA_STATEMENT:
				return basicSetPragmaStatement(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SsmePackage.PRAGMA__IDENTIFIER:
				return getIdentifier();
			case SsmePackage.PRAGMA__LIST_PRAGMA_OBJECT:
				return getListPragmaObject();
			case SsmePackage.PRAGMA__PRAGMA_STATEMENT:
				return getPragmaStatement();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SsmePackage.PRAGMA__IDENTIFIER:
				setIdentifier((Identifier)newValue);
				return;
			case SsmePackage.PRAGMA__LIST_PRAGMA_OBJECT:
				getListPragmaObject().clear();
				getListPragmaObject().addAll((Collection<? extends Identifier>)newValue);
				return;
			case SsmePackage.PRAGMA__PRAGMA_STATEMENT:
				setPragmaStatement((StringValue)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SsmePackage.PRAGMA__IDENTIFIER:
				setIdentifier((Identifier)null);
				return;
			case SsmePackage.PRAGMA__LIST_PRAGMA_OBJECT:
				getListPragmaObject().clear();
				return;
			case SsmePackage.PRAGMA__PRAGMA_STATEMENT:
				setPragmaStatement((StringValue)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SsmePackage.PRAGMA__IDENTIFIER:
				return identifier != null;
			case SsmePackage.PRAGMA__LIST_PRAGMA_OBJECT:
				return listPragmaObject != null && !listPragmaObject.isEmpty();
			case SsmePackage.PRAGMA__PRAGMA_STATEMENT:
				return pragmaStatement != null;
		}
		return super.eIsSet(featureID);
	}

} //PragmaImpl
