/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.pop.ssme.PredefinedType;
import org.eclipse.pop.ssme.SignalIntrinsicType;
import org.eclipse.pop.ssme.SsmePackage;
import org.eclipse.pop.ssme.polychrony.PKTrees;
import org.eclipse.pop.ssme.polychrony.PkPlugin;
import org.eclipse.pop.ssme.polychrony.SignalOperators;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Predefined Type</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.impl.PredefinedTypeImpl#getType <em>Type</em>}</li>
 * </ul>
 *
 * @generated
 */
public class PredefinedTypeImpl extends SignalElementImpl implements PredefinedType {
	/**
	 * The default value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected static final SignalIntrinsicType TYPE_EDEFAULT = SignalIntrinsicType.UNDEFINED_LITERAL;

	/**
	 * The cached value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected SignalIntrinsicType type = TYPE_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PredefinedTypeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SsmePackage.eINSTANCE.getPredefinedType();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SignalIntrinsicType getType() {
		return type;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setType(SignalIntrinsicType newType) {
		SignalIntrinsicType oldType = type;
		type = newType == null ? TYPE_EDEFAULT : newType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.PREDEFINED_TYPE__TYPE, oldType, type));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public long makeAST() {
		PKTrees API = PkPlugin.getTreeAPI();
		long result = API.getNilTree();
		if (getType().equals(SignalIntrinsicType.EVENT_LITERAL)) {
			result = API.makeNullary(SignalOperators.opevent);
		}
		if (getType().equals(SignalIntrinsicType.BOOLEAN_LITERAL)) {
			result = API.makeNullary(SignalOperators.oplogical);
		}
		if (getType().equals(SignalIntrinsicType.SHORT_LITERAL)) {
			result = API.makeNullary(SignalOperators.opshort);
		}
		if (getType().equals(SignalIntrinsicType.INTEGER_LITERAL)) {
			result = API.makeNullary(SignalOperators.opinteger);
		}
		if (getType().equals(SignalIntrinsicType.LONG_LITERAL)) {
			result = API.makeNullary(SignalOperators.oplong);
		}
		if (getType().equals(SignalIntrinsicType.REAL_LITERAL)) {
			result = API.makeNullary(SignalOperators.opreal);
		}
		if (getType().equals(SignalIntrinsicType.DREAL_LITERAL)) {
			result = API.makeNullary(SignalOperators.opdpreal);
		}
		if (getType().equals(SignalIntrinsicType.COMPLEX_LITERAL)) {
			result = API.makeNullary(SignalOperators.opcomplex);
		}
		if (getType().equals(SignalIntrinsicType.DCOMPLEX_LITERAL)) {
			result = API.makeNullary(SignalOperators.opdcomplex);
		}
		if (getType().equals(SignalIntrinsicType.CHAR_LITERAL)) {
			result = API.makeNullary(SignalOperators.opchar);
		}
		if (getType().equals(SignalIntrinsicType.STRING_LITERAL)) {
			result = API.makeNullary(SignalOperators.opstring);
		}
		setASTAttribute(this, result);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SsmePackage.PREDEFINED_TYPE__TYPE:
				return getType();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SsmePackage.PREDEFINED_TYPE__TYPE:
				setType((SignalIntrinsicType)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SsmePackage.PREDEFINED_TYPE__TYPE:
				setType(TYPE_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SsmePackage.PREDEFINED_TYPE__TYPE:
				return type != TYPE_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (type: ");
		result.append(type);
		result.append(')');
		return result.toString();
	}

} //PredefinedTypeImpl
