/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.pop.ssme.ListExprSignal;
import org.eclipse.pop.ssme.ProcessCall;
import org.eclipse.pop.ssme.ReferenceProcess;
import org.eclipse.pop.ssme.SsmePackage;
import org.eclipse.pop.ssme.polychrony.PKTrees;
import org.eclipse.pop.ssme.polychrony.PkPlugin;
import org.eclipse.pop.ssme.polychrony.SignalOperators;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Process Call</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.impl.ProcessCallImpl#getReferenceProcess <em>Reference Process</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.impl.ProcessCallImpl#getListExprSignal <em>List Expr Signal</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ProcessCallImpl extends SignalElementImpl implements ProcessCall {
	/**
	 * The cached value of the '{@link #getReferenceProcess() <em>Reference Process</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getReferenceProcess()
	 * @generated
	 * @ordered
	 */
	protected ReferenceProcess referenceProcess;

	/**
	 * The cached value of the '{@link #getListExprSignal() <em>List Expr Signal</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getListExprSignal()
	 * @generated
	 * @ordered
	 */
	protected ListExprSignal listExprSignal;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ProcessCallImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SsmePackage.eINSTANCE.getProcessCall();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ReferenceProcess getReferenceProcess() {
		return referenceProcess;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetReferenceProcess(ReferenceProcess newReferenceProcess, NotificationChain msgs) {
		ReferenceProcess oldReferenceProcess = referenceProcess;
		referenceProcess = newReferenceProcess;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.PROCESS_CALL__REFERENCE_PROCESS, oldReferenceProcess, newReferenceProcess);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setReferenceProcess(ReferenceProcess newReferenceProcess) {
		if (newReferenceProcess != referenceProcess) {
			NotificationChain msgs = null;
			if (referenceProcess != null)
				msgs = ((InternalEObject)referenceProcess).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.PROCESS_CALL__REFERENCE_PROCESS, null, msgs);
			if (newReferenceProcess != null)
				msgs = ((InternalEObject)newReferenceProcess).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.PROCESS_CALL__REFERENCE_PROCESS, null, msgs);
			msgs = basicSetReferenceProcess(newReferenceProcess, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.PROCESS_CALL__REFERENCE_PROCESS, newReferenceProcess, newReferenceProcess));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ListExprSignal getListExprSignal() {
		return listExprSignal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetListExprSignal(ListExprSignal newListExprSignal, NotificationChain msgs) {
		ListExprSignal oldListExprSignal = listExprSignal;
		listExprSignal = newListExprSignal;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.PROCESS_CALL__LIST_EXPR_SIGNAL, oldListExprSignal, newListExprSignal);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setListExprSignal(ListExprSignal newListExprSignal) {
		if (newListExprSignal != listExprSignal) {
			NotificationChain msgs = null;
			if (listExprSignal != null)
				msgs = ((InternalEObject)listExprSignal).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.PROCESS_CALL__LIST_EXPR_SIGNAL, null, msgs);
			if (newListExprSignal != null)
				msgs = ((InternalEObject)newListExprSignal).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.PROCESS_CALL__LIST_EXPR_SIGNAL, null, msgs);
			msgs = basicSetListExprSignal(newListExprSignal, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.PROCESS_CALL__LIST_EXPR_SIGNAL, newListExprSignal, newListExprSignal));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case SsmePackage.PROCESS_CALL__REFERENCE_PROCESS:
				return basicSetReferenceProcess(null, msgs);
			case SsmePackage.PROCESS_CALL__LIST_EXPR_SIGNAL:
				return basicSetListExprSignal(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SsmePackage.PROCESS_CALL__REFERENCE_PROCESS:
				return getReferenceProcess();
			case SsmePackage.PROCESS_CALL__LIST_EXPR_SIGNAL:
				return getListExprSignal();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SsmePackage.PROCESS_CALL__REFERENCE_PROCESS:
				setReferenceProcess((ReferenceProcess)newValue);
				return;
			case SsmePackage.PROCESS_CALL__LIST_EXPR_SIGNAL:
				setListExprSignal((ListExprSignal)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SsmePackage.PROCESS_CALL__REFERENCE_PROCESS:
				setReferenceProcess((ReferenceProcess)null);
				return;
			case SsmePackage.PROCESS_CALL__LIST_EXPR_SIGNAL:
				setListExprSignal((ListExprSignal)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SsmePackage.PROCESS_CALL__REFERENCE_PROCESS:
				return referenceProcess != null;
			case SsmePackage.PROCESS_CALL__LIST_EXPR_SIGNAL:
				return listExprSignal != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public long makeAST() {
		PKTrees API = PkPlugin.getTreeAPI();
		long result = PKTrees.ERROR_NODE;
		long refProcNode = API.getNilTree();
		long lExprSignalNode = API.getNilTree();
		
		if (getReferenceProcess() != null) {
			refProcNode = getReferenceProcess().makeAST();
		}
		
		if (getListExprSignal() != null && !getListExprSignal().getExprSignal().isEmpty()) {
			lExprSignalNode = getListExprSignal().makeAST();
		}
		else {
			lExprSignalNode = API.getNilTree();
		}
		
		if (refProcNode != PKTrees.ERROR_NODE) {
			result = API.makeBinary(SignalOperators.opappe, refProcNode, lExprSignalNode);
		}
		setASTAttribute(this, result);
		return result;
	}

} //ProcessCallImpl
