/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.pop.ssme.ExprParam;
import org.eclipse.pop.ssme.Identifier;
import org.eclipse.pop.ssme.ProcessExpansion;
import org.eclipse.pop.ssme.SsmePackage;
import org.eclipse.pop.ssme.polychrony.PKTrees;
import org.eclipse.pop.ssme.polychrony.PkPlugin;
import org.eclipse.pop.ssme.polychrony.SignalOperators;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Process Expansion</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.impl.ProcessExpansionImpl#getIdentifier <em>Identifier</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.impl.ProcessExpansionImpl#getListExprParam <em>List Expr Param</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ProcessExpansionImpl extends SignalElementImpl implements ProcessExpansion {
	/**
	 * The cached value of the '{@link #getIdentifier() <em>Identifier</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIdentifier()
	 * @generated
	 * @ordered
	 */
	protected Identifier identifier;

	/**
	 * The cached value of the '{@link #getListExprParam() <em>List Expr Param</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getListExprParam()
	 * @generated
	 * @ordered
	 */
	protected EList<ExprParam> listExprParam;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ProcessExpansionImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SsmePackage.eINSTANCE.getProcessExpansion();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Identifier getIdentifier() {
		return identifier;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetIdentifier(Identifier newIdentifier, NotificationChain msgs) {
		Identifier oldIdentifier = identifier;
		identifier = newIdentifier;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.PROCESS_EXPANSION__IDENTIFIER, oldIdentifier, newIdentifier);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIdentifier(Identifier newIdentifier) {
		if (newIdentifier != identifier) {
			NotificationChain msgs = null;
			if (identifier != null)
				msgs = ((InternalEObject)identifier).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.PROCESS_EXPANSION__IDENTIFIER, null, msgs);
			if (newIdentifier != null)
				msgs = ((InternalEObject)newIdentifier).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.PROCESS_EXPANSION__IDENTIFIER, null, msgs);
			msgs = basicSetIdentifier(newIdentifier, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.PROCESS_EXPANSION__IDENTIFIER, newIdentifier, newIdentifier));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<ExprParam> getListExprParam() {
		if (listExprParam == null) {
			listExprParam = new EObjectContainmentEList<ExprParam>(ExprParam.class, this, SsmePackage.PROCESS_EXPANSION__LIST_EXPR_PARAM);
		}
		return listExprParam;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case SsmePackage.PROCESS_EXPANSION__IDENTIFIER:
				return basicSetIdentifier(null, msgs);
			case SsmePackage.PROCESS_EXPANSION__LIST_EXPR_PARAM:
				return ((InternalEList<?>)getListExprParam()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SsmePackage.PROCESS_EXPANSION__IDENTIFIER:
				return getIdentifier();
			case SsmePackage.PROCESS_EXPANSION__LIST_EXPR_PARAM:
				return getListExprParam();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SsmePackage.PROCESS_EXPANSION__IDENTIFIER:
				setIdentifier((Identifier)newValue);
				return;
			case SsmePackage.PROCESS_EXPANSION__LIST_EXPR_PARAM:
				getListExprParam().clear();
				getListExprParam().addAll((Collection<? extends ExprParam>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SsmePackage.PROCESS_EXPANSION__IDENTIFIER:
				setIdentifier((Identifier)null);
				return;
			case SsmePackage.PROCESS_EXPANSION__LIST_EXPR_PARAM:
				getListExprParam().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SsmePackage.PROCESS_EXPANSION__IDENTIFIER:
				return identifier != null;
			case SsmePackage.PROCESS_EXPANSION__LIST_EXPR_PARAM:
				return listExprParam != null && !listExprParam.isEmpty();
		}
		return super.eIsSet(featureID);
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public long makeAST() {
		PKTrees API = PkPlugin.getTreeAPI();
		long result = PKTrees.ERROR_NODE;
		long identNode = API.getNilTree();
		long lExprParamNode = API.getNilTree();
		
		if (getIdentifier() != null) {
			identNode = getIdentifier().makeAST();
		}
		
		if (getListExprParam() != null && !getListExprParam().isEmpty()) {
			lExprParamNode = API.makeEmptyList(SignalOperators.oplepara);
			for (ExprParam eParam : getListExprParam()) {
				long eSigNode = eParam.makeAST();
				if (eSigNode != PKTrees.ERROR_NODE) {
					lExprParamNode = API.post(lExprParamNode, eSigNode);
				}
			}
		}
		else {
			lExprParamNode = API.getNilTree();
		}
		
		if (identNode != PKTrees.ERROR_NODE) {
			result = API.makeBinary(SignalOperators.opinst, identNode, lExprParamNode);
		}
		setASTAttribute(this, result);
		return result;
	}

} //ProcessExpansionImpl
